/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.interfaces;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.fixtures.Fixtures;
import dev.imabad.theatrical.util.RndUtils;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneInterfaceBlockEntity
extends ClientSyncBlockEntity
implements DMXConsumer {
    private int channelStartPoint;
    private int dmxUniverse = 0;
    private int redstoneOutput = 0;
    private RDMDeviceId deviceId;
    private UUID networkId = UUIDUtil.NULL;

    public RedstoneInterfaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.REDSTONE_INTERFACE.get(), blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        compoundTag.m_128405_("channelCount", 1);
        compoundTag.m_128405_("channelStartPoint", this.channelStartPoint);
        compoundTag.m_128405_("dmxUniverse", this.dmxUniverse);
        if (this.deviceId != null) {
            compoundTag.m_128382_("deviceId", this.deviceId.toBytes());
        }
        if (this.networkId != null) {
            compoundTag.m_128362_("network", this.networkId);
        }
    }

    @Override
    public void read(CompoundTag compoundTag) {
        this.channelStartPoint = compoundTag.m_128451_("channelStartPoint");
        if (compoundTag.m_128441_("dmxUniverse")) {
            this.dmxUniverse = compoundTag.m_128451_("dmxUniverse");
        }
        if (compoundTag.m_128441_("deviceId")) {
            this.deviceId = new RDMDeviceId(compoundTag.m_128463_("deviceId"));
        }
        if (compoundTag.m_128441_("network")) {
            this.networkId = compoundTag.m_128342_("network");
        }
    }

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    public int getChannelStart() {
        return this.channelStartPoint;
    }

    @Override
    public int getUniverse() {
        return this.dmxUniverse;
    }

    public int getRedstoneOutput() {
        return this.redstoneOutput;
    }

    @Override
    public RDMDeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    public int getDeviceTypeId() {
        return 4;
    }

    @Override
    public String getModelName() {
        return "Redstone Interface";
    }

    @Override
    public ResourceLocation getFixtureId() {
        return Fixtures.REDSTONE_INTERFACE.getId();
    }

    @Override
    public int getActivePersonality() {
        return 0;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(UUID networkId) {
        if (networkId == this.networkId) {
            return;
        }
        this.removeConsumer();
        this.networkId = networkId;
        this.addConsumer();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    private void generateDeviceId() {
        byte[] bytes = new byte[4];
        if (this.f_58857_ != null) {
            RndUtils.nextBytes(this.f_58857_.m_213780_(), bytes);
        } else {
            new Random().nextBytes(bytes);
        }
        this.deviceId = new RDMDeviceId(32752, bytes);
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    @Override
    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 1) {
            return;
        }
        int newOutput = (int)Math.round(Mth.m_144914_((double)this.convertByteToInt(ourValues[0]), (double)0.0, (double)255.0, (double)0.0, (double)15.0));
        if (newOutput != this.redstoneOutput) {
            this.redstoneOutput = newOutput;
            this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public void setChannelStartPoint(int channelStartPoint) {
        this.channelStartPoint = channelStartPoint;
        this.updateConsumer();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public void setUniverse(int universe) {
        if (this.dmxUniverse == universe) {
            return;
        }
        this.removeConsumer();
        this.dmxUniverse = universe;
        this.addConsumer();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    private void updateConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.updateConsumer(this);
        }
    }

    private void addConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId);
        if (dmxData != null) {
            if (this.deviceId == null) {
                this.generateDeviceId();
            }
            dmxData.addConsumer(this.m_58899_(), this);
        }
    }

    private void removeConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.removeConsumer(this, this.m_58899_());
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level != null && !level.f_46443_) {
            this.addConsumer();
        }
    }

    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.removeConsumer();
        }
        super.m_7651_();
    }
}

