/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import dev.imabad.theatrical.api.DynamicLightProvider;
import dev.imabad.theatrical.api.FixtureProvider;
import dev.imabad.theatrical.api.Support;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.blockentities.light.LEDPanelBlockEntity;
import dev.imabad.theatrical.blockentities.light.LightCollisionContext;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.blocks.light.BaseLightBlock;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.lighting.LightManager;
import dev.imabad.theatrical.mixin.ClipContextAccessor;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class BaseLightBlockEntity
extends ClientSyncBlockEntity
implements FixtureProvider,
DynamicLightProvider {
    AABB INFINITE_EXTENT_AABB = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private double distance = 0.0;
    protected int pan;
    protected int tilt;
    protected int focus;
    protected int intensity;
    protected int red;
    protected int green;
    protected int blue = 0;
    protected int prevTilt;
    protected int prevPan;
    protected int prevFocus;
    protected int prevIntensity;
    protected int prevRed;
    protected int prevGreen;
    protected int prevBlue;
    protected int prevColour = 0;
    protected float prevSpread = 0.0f;
    private long tickTimer = 0L;
    private BlockPos emissionBlock;
    private BlockPos prevEmissionBlock;
    private int prevLuminance;
    private LongOpenHashSet trackedLitChunkPos = new LongOpenHashSet();

    public BaseLightBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        if (compoundTag == null) {
            compoundTag = new CompoundTag();
        }
        compoundTag.m_128405_("pan", this.pan);
        compoundTag.m_128405_("tilt", this.tilt);
        compoundTag.m_128405_("focus", this.focus);
        compoundTag.m_128356_("timer", this.tickTimer);
        compoundTag.m_128347_("distance", this.distance);
        compoundTag.m_128405_("intensity", this.intensity);
        compoundTag.m_128405_("prevIntensity", this.prevIntensity);
        compoundTag.m_128405_("red", this.red);
        compoundTag.m_128405_("green", this.green);
        compoundTag.m_128405_("blue", this.blue);
        compoundTag.m_128405_("prevRed", this.prevRed);
        compoundTag.m_128405_("prevGreen", this.prevGreen);
        compoundTag.m_128405_("prevBlue", this.prevBlue);
    }

    @Override
    public void read(CompoundTag compoundTag) {
        this.pan = compoundTag.m_128451_("pan");
        this.tilt = compoundTag.m_128451_("tilt");
        this.focus = compoundTag.m_128451_("focus");
        this.prevPan = this.pan;
        this.prevTilt = this.tilt;
        this.prevFocus = this.focus;
        this.tickTimer = compoundTag.m_128454_("timer");
        this.distance = compoundTag.m_128459_("distance");
        this.intensity = compoundTag.m_128451_("intensity");
        this.prevIntensity = compoundTag.m_128451_("prevIntensity");
        this.red = compoundTag.m_128451_("red");
        this.green = compoundTag.m_128451_("green");
        this.blue = compoundTag.m_128451_("blue");
        this.prevRed = compoundTag.m_128451_("prevRed");
        this.prevGreen = compoundTag.m_128451_("prevGreen");
        this.prevBlue = compoundTag.m_128451_("prevBlue");
    }

    public double getDistance() {
        return this.distance;
    }

    public AABB getRenderBoundingBox() {
        return this.INFINITE_EXTENT_AABB;
    }

    public BlockPos getEmissionBlock() {
        return this.emissionBlock;
    }

    public BlockPos getPrevEmissionBlock() {
        return this.prevEmissionBlock;
    }

    public void setPrevEmissionBlock(BlockPos prevEmissionBlock) {
        this.prevEmissionBlock = prevEmissionBlock;
    }

    public int getPrevLuminance() {
        return this.prevLuminance;
    }

    public void setPrevLuminance(int prevLuminance) {
        this.prevLuminance = prevLuminance;
    }

    public LongOpenHashSet getTrackedLitChunkPos() {
        return this.trackedLitChunkPos;
    }

    public void setTrackedLitChunkPos(LongOpenHashSet trackedLitChunkPos) {
        this.trackedLitChunkPos = trackedLitChunkPos;
    }

    protected boolean storePrev() {
        boolean hasChanged = false;
        if (this.tilt != this.prevTilt) {
            this.prevTilt = this.tilt;
            hasChanged = true;
        }
        if (this.pan != this.prevPan) {
            this.prevPan = this.pan;
            hasChanged = true;
        }
        if (this.focus != this.prevFocus) {
            this.prevFocus = this.focus;
            hasChanged = true;
        }
        if (this.intensity != this.prevIntensity) {
            this.prevIntensity = this.intensity;
            hasChanged = true;
        }
        if (this.red != this.prevRed) {
            this.prevRed = this.red;
            hasChanged = true;
        }
        if (this.green != this.prevGreen) {
            this.prevGreen = this.green;
            hasChanged = true;
        }
        if (this.blue != this.prevBlue) {
            this.prevBlue = this.blue;
            hasChanged = true;
        }
        return hasChanged;
    }

    @Override
    public float getIntensity() {
        return this.intensity;
    }

    @Override
    public float getMaxLightDistance() {
        return TheatricalConfig.INSTANCE.COMMON.defaultMaxLightDist;
    }

    @Override
    public boolean shouldTrace() {
        return this.getIntensity() > 0.0f;
    }

    @Override
    public boolean emitsLight() {
        return (Boolean)this.m_58900_().m_61143_((Property)HangableBlock.BROKEN) == false && TheatricalConfig.INSTANCE.COMMON.shouldEmitLight;
    }

    @Override
    public boolean isUpsideDown() {
        return false;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        BaseLightBlockEntity tile = (BaseLightBlockEntity)be;
        ++tile.tickTimer;
        if (tile.tickTimer >= 5L) {
            tile.tickTimer = 0L;
        }
        if (tile.shouldTrace()) {
            tile.distance = tile.doRayTrace();
        }
        if (level.m_5776_() && LightManager.shouldUpdateDynamicLight()) {
            if (tile.m_58901_()) {
                tile.setLightEnabled(false);
            } else {
                tile.lightTick();
                LightManager.updateTracking(tile);
            }
        }
    }

    public int getPan() {
        return this.pan;
    }

    public int getTilt() {
        return this.tilt;
    }

    public int getFocus() {
        return this.focus;
    }

    public int getPrevTilt() {
        return this.prevTilt;
    }

    public int getPrevPan() {
        return this.prevPan;
    }

    public int getPrevFocus() {
        return this.prevFocus;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getPrevIntensity() {
        return this.prevIntensity;
    }

    public int getPrevRed() {
        return this.prevRed;
    }

    public int getPrevGreen() {
        return this.prevGreen;
    }

    public int getPrevBlue() {
        return this.prevBlue;
    }

    public int getColorHex() {
        return this.getRed() << 16 | this.getGreen() << 8 | this.getBlue();
    }

    public int getPrevColor() {
        return this.getPrevRed() << 16 | this.getPrevGreen() << 8 | this.getPrevBlue();
    }

    public int getPrevColour() {
        return this.prevColour;
    }

    public void setPrevColour(int prevColour) {
        this.prevColour = prevColour;
    }

    public Optional<BlockState> getSupportingStructure() {
        BlockState blockState;
        if (this.m_58904_() != null && (blockState = this.m_58904_().m_8055_(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)HangableBlock.HANG_DIRECTION)))).m_60734_() instanceof Support) {
            return Optional.of(blockState);
        }
        return Optional.empty();
    }

    public int getBasePan() {
        if (BaseLightBlockEntity.isHangingNonVertically(this.m_58900_())) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)BaseLightBlock.FACING);
            return switch (facing) {
                case Direction.NORTH, Direction.SOUTH -> 90;
                case Direction.WEST -> 180;
                default -> 0;
            };
        }
        return 0;
    }

    public int calculatePartialColour(float partialTicks) {
        int r = (int)((float)this.getPrevRed() + (float)(this.getRed() - this.getPrevRed()) * partialTicks);
        int g = (int)((float)this.getPrevGreen() + (float)(this.getGreen() - this.getPrevGreen()) * partialTicks);
        int b = (int)((float)this.getPrevBlue() + (float)(this.getBlue() - this.getPrevBlue()) * partialTicks);
        return r << 16 | g << 8 | b;
    }

    public int getColour() {
        return this.getRed() << 16 | this.getGreen() << 8 | this.getBlue();
    }

    public static final Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float g = -yRot * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    public static boolean isHangingNonVertically(BlockState blockState) {
        return BaseLightBlockEntity.isHangingNonVertically((Direction)blockState.m_61143_((Property)BaseLightBlock.HANG_DIRECTION), (Boolean)blockState.m_61143_((Property)BaseLightBlock.HANGING));
    }

    public static boolean isHangingNonVertically(Direction hangDirection, boolean isHanging) {
        return hangDirection != Direction.DOWN && hangDirection != Direction.UP && isHanging;
    }

    public static Vec3 rayTraceDir(BaseLightBlockEntity be) {
        BlockState blockState = be.m_58900_();
        Direction hangDirection = (Direction)blockState.m_61143_((Property)BaseLightBlock.HANG_DIRECTION);
        Direction direction = (Direction)blockState.m_61143_((Property)BaseLightBlock.FACING);
        boolean isHangingNonVertically = BaseLightBlockEntity.isHangingNonVertically(hangDirection, (Boolean)blockState.m_61143_((Property)BaseLightBlock.HANGING));
        if (!isHangingNonVertically) {
            float tilt = be.getTilt();
            if (be.isUpsideDown() || be.getFixture().invertTilt()) {
                tilt = -tilt;
            }
            if (be instanceof LEDPanelBlockEntity) {
                if (blockState.m_61143_((Property)BaseLightBlock.HANG_DIRECTION) == Direction.DOWN) {
                    tilt = -90.0f;
                } else if (blockState.m_61143_((Property)BaseLightBlock.HANG_DIRECTION) == Direction.UP) {
                    tilt = 90.0f;
                }
            }
            float pan = direction.m_122435_() - (float)be.getPan();
            if (direction.m_122434_() == Direction.WEST.m_122434_()) {
                pan -= 180.0f;
            }
            if (be.getFixture().invertPan()) {
                pan *= -1.0f;
            }
            if (be.isUpsideDown()) {
                pan = direction.m_122434_() == Direction.Axis.X ? direction.m_122424_().m_122435_() + (float)be.getPan() : direction.m_122435_() + (float)be.getPan();
            }
            return BaseLightBlockEntity.calculateViewVector(tilt, pan);
        }
        Direction opposite = hangDirection.m_122424_();
        int step = opposite.m_122421_().m_122540_();
        float offset = 0.0f;
        float toRad = 0.01745328f;
        float pan = be.getBasePan() + be.getPan();
        float tilt = be.getTilt();
        float sinPan = Mth.m_14031_((float)((pan *= (float)step * toRad) + offset));
        float cosPan = Mth.m_14089_((float)(pan + offset));
        float cosTilt = Mth.m_14089_((float)(tilt *= (float)(-step) * toRad));
        float x = sinPan * cosTilt;
        float y = Mth.m_14031_((float)tilt);
        float z = cosPan * cosTilt;
        AxisCycle cycle = AxisCycle.f_121784_[(opposite.m_122434_().ordinal() + 2) % AxisCycle.f_121784_.length];
        return new Vec3(cycle.m_142567_((double)x, (double)y, (double)z, Direction.Axis.X), cycle.m_142567_((double)x, (double)y, (double)z, Direction.Axis.Y), cycle.m_142567_((double)x, (double)y, (double)z, Direction.Axis.Z));
    }

    public double doRayTrace() {
        Vec3 viewVector = BaseLightBlockEntity.rayTraceDir(this);
        double distance = this.getMaxLightDistance();
        Vec3 vec3 = this.m_58899_().m_252807_();
        Vec3 vec33 = vec3.m_82520_(viewVector.f_82479_ * distance, viewVector.f_82480_ * distance, viewVector.f_82481_ * distance);
        ClipContext context = new ClipContext(vec3, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        ((ClipContextAccessor)context).setCollisionContext(new LightCollisionContext(this.m_58899_()));
        BlockHitResult result = this.f_58857_.m_45547_(context);
        BlockPos lightPos = result.m_82425_();
        if (result.m_6662_() != HitResult.Type.MISS && !result.m_82436_()) {
            distance = result.m_82450_().m_82554_(vec3);
            if (!result.m_82425_().equals((Object)this.m_58899_())) {
                lightPos = result.m_82425_().m_5484_(result.m_82434_(), 1);
            }
        }
        distance = new Vec3((double)lightPos.m_123341_(), (double)lightPos.m_123342_(), (double)lightPos.m_123343_()).m_82554_(new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()));
        this.emissionBlock = lightPos;
        return distance;
    }

    public void m_7651_() {
        if (this.emissionBlock != null) {
            this.setLightEnabled(false);
            this.emissionBlock = null;
        }
        super.m_7651_();
    }

    public void setTilt(int tilt) {
        this.prevTilt = this.tilt;
        this.tilt = tilt;
    }

    public void setPan(int pan) {
        this.prevPan = this.pan;
        this.pan = pan;
    }

    @Override
    public int getLightLuminance() {
        float newVal = (float)this.intensity / 255.0f;
        return (int)(newVal * 15.0f);
    }

    @Override
    public Vector3f getLightPos() {
        return Vec3.m_82512_((Vec3i)this.emissionBlock).m_252839_();
    }

    @Override
    public boolean isLightEnabled() {
        return DynamicLightProvider.super.isLightEnabled();
    }

    @Override
    public void resetLight() {
    }

    @Override
    public void lightTick() {
    }

    @Override
    public boolean shouldUpdateLight() {
        return LightManager.shouldUpdateDynamicLight() && this.emitsLight() && this.emissionBlock != null;
    }

    @Override
    public boolean updateDynamicLight(LevelRenderer renderer) {
        if (!this.shouldUpdateLight()) {
            return false;
        }
        return LightManager.updateDynamicLight(this, renderer);
    }

    @Override
    public void scheduleTrackedChunksRebuild(LevelRenderer renderer) {
        if (Minecraft.m_91087_().f_91073_ == this.f_58857_) {
            LongIterator longIterator = this.trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LightManager.scheduleChunkRebuild(renderer, pos);
            }
        }
    }

    @Override
    public BlockPos getOwnerPos() {
        return this.m_58899_();
    }

    @Override
    public int getLightColour() {
        return (int)this.getIntensity() << 24 | this.getColour();
    }

    public float getPrevSpread() {
        return this.prevSpread;
    }

    public void setPrevSpread(float prevSpread) {
        this.prevSpread = prevSpread;
    }

    @Override
    public float getLightSpread() {
        float focus = (float)this.getFocus() / 255.0f;
        float minRadius = 1.0f;
        float maxRadius = (float)this.getFixture().getLightRadius();
        float clampedSpread = Mth.m_14036_((float)focus, (float)0.05f, (float)1.0f);
        return Mth.m_14179_((float)clampedSpread, (float)minRadius, (float)maxRadius);
    }

    @Override
    public Level getLightWorld() {
        return this.m_58904_();
    }
}

