/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import dev.imabad.theatrical.fixtures.Fixtures;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FresnelBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    public FresnelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.LED_FRESNEL.get(), pos, state);
        this.setChannelCount(4);
    }

    @Override
    public Fixture getFixture() {
        return (Fixture)Fixtures.LED_FRESNEL.get();
    }

    @Override
    public int getFocus() {
        return 1;
    }

    @Override
    public void consume(byte[] dmxValues) {
        int newBlue;
        int newGreen;
        int newRed;
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 4) {
            return;
        }
        if (this.storePrev()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        boolean hasUpdated = false;
        int newIntensity = this.convertByteToInt(ourValues[0]);
        if (this.intensity != newIntensity) {
            this.intensity = newIntensity;
            hasUpdated = true;
        }
        if (this.red != (newRed = this.convertByteToInt(ourValues[1]))) {
            this.red = newRed;
            hasUpdated = true;
        }
        if (this.green != (newGreen = this.convertByteToInt(ourValues[2]))) {
            this.green = newGreen;
            hasUpdated = true;
        }
        if (this.blue != (newBlue = this.convertByteToInt(ourValues[3]))) {
            this.blue = newBlue;
            hasUpdated = true;
        }
        if (hasUpdated) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public int getDeviceTypeId() {
        return 2;
    }

    @Override
    public String getModelName() {
        return "LED Fresnel";
    }

    @Override
    public ResourceLocation getFixtureId() {
        return Fixtures.LED_FRESNEL.getId();
    }

    @Override
    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }
}

