/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import dev.imabad.theatrical.blocks.light.MovingWashBlock;
import dev.imabad.theatrical.fixtures.Fixtures;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MovingWashBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    public MovingWashBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.setChannelCount(7);
    }

    public MovingWashBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntities.MOVING_WASH.get(), pos, state);
    }

    @Override
    public Fixture getFixture() {
        return (Fixture)Fixtures.MOVING_WASH.get();
    }

    @Override
    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 7) {
            return;
        }
        if (this.storePrev()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        this.intensity = this.convertByteToInt(ourValues[0]);
        this.red = this.convertByteToInt(ourValues[1]);
        this.green = this.convertByteToInt(ourValues[2]);
        this.blue = this.convertByteToInt(ourValues[3]);
        this.focus = this.convertByteToInt(ourValues[4]);
        this.pan = (int)((float)(this.convertByteToInt(ourValues[5]) * 360) / 255.0f) - 180;
        this.tilt = (int)((float)(this.convertByteToInt(ourValues[6]) * 270) / 255.0f) - 225;
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        this.m_6596_();
    }

    @Override
    public int getDeviceTypeId() {
        return 1;
    }

    @Override
    public String getModelName() {
        return "Moving Wash";
    }

    @Override
    public ResourceLocation getFixtureId() {
        return Fixtures.MOVING_WASH.getId();
    }

    @Override
    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    @Override
    public boolean isUpsideDown() {
        return (Boolean)this.m_58900_().m_61143_((Property)MovingWashBlock.HANGING) != false && this.m_58900_().m_61143_((Property)MovingWashBlock.HANG_DIRECTION) == Direction.UP;
    }

    @Override
    public int getBasePan() {
        return 0;
    }
}

