/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.imabad.theatrical.blockentities.control.BasicLightingDeskBlockEntity;
import dev.imabad.theatrical.client.TheatricalRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class BasicLightingConsoleRenderer
implements BlockEntityRenderer<BasicLightingDeskBlockEntity> {
    public BasicLightingConsoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public float convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public void render(BasicLightingDeskBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        BlockState blockState = blockEntity.m_58900_();
        Direction blockDirection = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (blockDirection.m_122434_() == Direction.Axis.X) {
            blockDirection = blockDirection.m_122424_();
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(blockDirection.m_122435_()));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        double startX = 1.5;
        byte[] faders = blockEntity.getFaders();
        VertexConsumer linesVertexBuilder = buffer.m_6299_(RenderType.m_110504_());
        for (int i = 0; i < faders.length; ++i) {
            double baseY = 5.4;
            if (i >= 6) {
                baseY += (double)(i / 6 * 7);
            }
            int faderNumber = i - i / 6 * 6;
            this.renderLine(poseStack, startX + (double)faderNumber * 1.2, baseY, linesVertexBuilder);
        }
        this.renderLine(poseStack, 14.5, 5.4, linesVertexBuilder);
        VertexConsumer iVertexBuilder = buffer.m_6299_(TheatricalRenderTypes.FADER);
        for (int i = 0; i < faders.length; ++i) {
            double baseY = 5.4;
            if (i >= 6) {
                baseY += (double)(i / 6 * 7);
            }
            int faderNumber = i - i / 6 * 6;
            this.renderFader(poseStack, startX + (double)faderNumber * 1.2, baseY, -(this.convertByteToInt(faders[i]) / 255.0f * 3.0f), iVertexBuilder);
        }
        this.renderFader(poseStack, 14.5, 5.4, -(this.convertByteToInt(blockEntity.getGrandMaster()) / 255.0f * 3.0f), iVertexBuilder);
        poseStack.m_85849_();
    }

    public void renderStep(PoseStack stack, BasicLightingDeskBlockEntity tileEntityBasicLightingControl, MultiBufferSource buffer, int combinedLightIn) {
        stack.m_85836_();
        Font font = Minecraft.m_91087_().f_91062_;
        stack.m_85837_(0.66875, 0.1875, 0.58125);
        stack.m_85841_(0.005f, -0.005f, 0.005f);
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        font.m_271703_("STEP", 0.0f, 0.0f, -1, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        stack.m_85849_();
    }

    public void renderCurrentMode(PoseStack stack, BasicLightingDeskBlockEntity tileEntityBasicLightingControl, MultiBufferSource buffer, int combinedLightIn) {
        stack.m_85836_();
        Font font = Minecraft.m_91087_().f_91062_;
        stack.m_85837_(0.65, 0.1875, 0.51875);
        stack.m_85841_(0.003f, -0.003f, 0.003f);
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        font.m_271703_(tileEntityBasicLightingControl.isRunMode() ? "Run mode" : "Program mode", 0.0f, 0.0f, 0, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        stack.m_85849_();
    }

    public void renderLine(PoseStack stack, double x, double y, VertexConsumer vertexBuilder) {
        stack.m_85836_();
        Matrix4f m = stack.m_85850_().m_252922_();
        stack.m_85837_(x / 16.0, 0.1875, y / 16.0);
        vertexBuilder.m_252986_(m, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_252986_(m, 0.0f, 0.0f, -0.1875f).m_6122_(0, 0, 0, 255).m_5601_(0.0f, 0.0f, 0.0f).m_5752_();
        stack.m_85849_();
    }

    public void renderFader(PoseStack stack, double x, double baseY, double faderY, VertexConsumer builder) {
        stack.m_85836_();
        Matrix4f m = stack.m_85850_().m_252922_();
        float height = 0.025f;
        float width = 0.0375f;
        stack.m_85837_(x / 16.0 - (double)(width / 2.0f), 0.1875, (baseY + faderY) / 16.0);
        builder.m_252986_(m, width, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, height, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, 0.0f, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, 0.0f, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, 0.0f, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, height, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, height, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, 0.0f, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, height, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, 0.0f, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, 0.0f, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, 0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, 0.0f, height, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, height, width).m_6122_(0, 0, 0, 255).m_5752_();
        builder.m_252986_(m, width, height, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        stack.m_85849_();
    }
}

