/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.imabad.theatrical.blockentities.light.BaseLightBlockEntity;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.blocks.light.MovingLightBlock;
import dev.imabad.theatrical.client.LazyRenderers;
import dev.imabad.theatrical.client.TheatricalRenderTypes;
import dev.imabad.theatrical.config.TheatricalConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class FixtureRenderer<T extends BaseLightBlockEntity>
implements BlockEntityRenderer<T> {
    private final Double beamOpacity;

    public FixtureRenderer(BlockEntityRendererProvider.Context context) {
        this.beamOpacity = TheatricalConfig.INSTANCE.CLIENT.beamOpacity;
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110463_());
        BlockState blockState = blockEntity.m_58900_();
        boolean isFlipped = ((BaseLightBlockEntity)blockEntity).isUpsideDown();
        boolean isHanging = ((HangableBlock)blockState.m_60734_()).isHanging((LevelReader)blockEntity.m_58904_(), blockEntity.m_58899_());
        Direction facing = (Direction)blockState.m_61143_((Property)MovingLightBlock.FACING);
        this.renderModel(blockEntity, poseStack, vertexConsumer, facing, partialTick, isFlipped, blockState, isHanging, packedLight, packedOverlay);
        this.beforeRenderBeam(blockEntity, poseStack, vertexConsumer, multiBufferSource, facing, partialTick, isFlipped, blockState, isHanging, packedLight, packedOverlay);
        if (this.shouldRenderBeam(blockEntity)) {
            LazyRenderers.addLazyRender(new LazyRenderers.LazyRenderer((BaseLightBlockEntity)blockEntity, facing, isFlipped, blockState, isHanging){
                final /* synthetic */ BaseLightBlockEntity val$blockEntity;
                final /* synthetic */ Direction val$facing;
                final /* synthetic */ boolean val$isFlipped;
                final /* synthetic */ BlockState val$blockState;
                final /* synthetic */ boolean val$isHanging;
                {
                    this.val$blockEntity = baseLightBlockEntity;
                    this.val$facing = direction;
                    this.val$isFlipped = bl;
                    this.val$blockState = blockState;
                    this.val$isHanging = bl2;
                }

                @Override
                public void render(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, Camera camera, float partialTick) {
                    poseStack.m_85836_();
                    Vec3 offset = Vec3.m_82528_((Vec3i)this.val$blockEntity.m_58899_()).m_82546_(camera.m_90583_());
                    poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                    FixtureRenderer.this.preparePoseStack(this.val$blockEntity, poseStack, this.val$facing, partialTick, this.val$isFlipped, this.val$blockState, this.val$isHanging);
                    VertexConsumer beamConsumer = bufferSource.m_6299_(TheatricalRenderTypes.BEAM);
                    poseStack.m_252880_(this.val$blockEntity.getFixture().getBeamStartPosition()[0], this.val$blockEntity.getFixture().getBeamStartPosition()[1], this.val$blockEntity.getFixture().getBeamStartPosition()[2]);
                    float intensity = this.val$blockEntity.getIntensity();
                    int color = this.val$blockEntity.getColour();
                    if (color != 0) {
                        FixtureRenderer.this.renderLightBeam(beamConsumer, poseStack, this.val$blockEntity, partialTick, (float)((double)intensity * FixtureRenderer.this.beamOpacity / 255.0), this.val$blockEntity.getFixture().getBeamWidth(), (float)this.val$blockEntity.getDistance(), color);
                    }
                    poseStack.m_85849_();
                }

                @Override
                public Vec3 getPos(float partialTick) {
                    return this.val$blockEntity.m_58899_().m_252807_();
                }
            });
        }
        poseStack.m_85849_();
    }

    public abstract void renderModel(T var1, PoseStack var2, VertexConsumer var3, Direction var4, float var5, boolean var6, BlockState var7, boolean var8, int var9, int var10);

    public abstract void preparePoseStack(T var1, PoseStack var2, Direction var3, float var4, boolean var5, BlockState var6, boolean var7);

    public void beforeRenderBeam(T blockEntity, PoseStack poseStack, VertexConsumer vertexConsumer, MultiBufferSource multiBufferSource, Direction facing, float partialTicks, boolean isFlipped, BlockState blockstate, boolean isHanging, int packedLight, int packedOverlay) {
    }

    public boolean shouldRenderBeam(T blockEntity) {
        return ((BaseLightBlockEntity)blockEntity).getIntensity() > 0.0f && blockEntity.getFixture().hasBeam();
    }

    protected void minecraftRenderModel(PoseStack poseStack, VertexConsumer vertexConsumer, BlockState blockState, BakedModel model, int packedLight, int packedOverlay) {
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), vertexConsumer, blockState, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
    }

    protected void renderLightBeam(VertexConsumer builder, PoseStack stack, T tileEntityFixture, float partialTicks, float alpha, float beamSize, float length, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = (int)(alpha * 255.0f);
        Matrix4f m = stack.m_85850_().m_252922_();
        Matrix3f normal = stack.m_85850_().m_252943_();
        float endMultiplier = beamSize * (float)((BaseLightBlockEntity)tileEntityFixture).getFocus();
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, -beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, -beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, 0, beamSize * endMultiplier, -beamSize * endMultiplier, -length);
        this.addVertex(builder, m, normal, r, g, b, a, beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, a, -beamSize, -beamSize, 0.0f);
        this.addVertex(builder, m, normal, r, g, b, 0, -beamSize * endMultiplier, -beamSize * endMultiplier, -length);
    }

    protected void addVertex(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, int r, int g, int b, int a, float x, float y, float z) {
        builder.m_252986_(matrix4f, x, y, z).m_6122_(r, g, b, a).m_5752_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public int m_142163_() {
        return TheatricalConfig.INSTANCE.CLIENT.renderDistance;
    }

    public boolean shouldRender(T blockEntity, Vec3 cameraPos) {
        return true;
    }
}

