/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.client.gui.widgets.ArtNetUniverseConfigurationList;
import dev.imabad.theatrical.client.gui.widgets.LabeledEditBox;
import dev.imabad.theatrical.config.ConfigHandler;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.config.UniverseConfig;
import dev.imabad.theatrical.util.UUIDUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ArtNetConfigurationScreen
extends Screen {
    private int xCenter;
    private int yCenter;
    private EditBox ipAddressBox;
    private EditBox networkUniverse;
    private EditBox subnet;
    private EditBox universe;
    private Checkbox universeEnabled;
    private Button deleteConfig;
    private IntObjectMap<UniverseConfig> universeConfigs = new IntObjectHashMap();
    private String ipAddress;
    private boolean enabled;
    private UUID networkId;
    private Screen lastScreen;
    private GridLayout layout;
    private ArtNetUniverseConfigurationList configList;

    public ArtNetConfigurationScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"button.artnetconfig"));
        this.ipAddress = TheatricalConfig.INSTANCE.CLIENT.artNetIP;
        this.enabled = TheatricalConfig.INSTANCE.CLIENT.artnetEnabled;
        this.universeConfigs = new IntObjectHashMap();
        TheatricalConfig.INSTANCE.CLIENT.universes.forEach((integer, universeConfig) -> this.universeConfigs.put(integer, (Object)new UniverseConfig(universeConfig.subnet, universeConfig.universe, universeConfig.enabled)));
        this.networkId = TheatricalClient.getArtNetManager().getNetworkId();
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.layout = new GridLayout();
        this.layout.m_264211_().m_264356_().m_264174_(5);
        this.xCenter = this.f_96543_ / 2;
        this.yCenter = this.f_96544_ / 2;
        this.ipAddressBox = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 100, 20, (Component)Component.m_237115_((String)"artneti.ipAddress")).color(0xFFFFFF).shadow(true);
        this.ipAddressBox.m_94144_(this.ipAddress);
        this.layout.m_264188_((LayoutElement)this.ipAddressBox, 1, 1, 1, 2);
        this.configList = new ArtNetUniverseConfigurationList(Minecraft.m_91087_(), this, 150, 100, (Component)Component.m_237113_((String)"test"));
        this.layout.m_264167_((LayoutElement)this.configList, 2, 1, 2, 1, LayoutSettings.m_264214_().m_264356_().m_264154_(0));
        this.configList.setEntries((Map<Integer, UniverseConfig>)this.universeConfigs);
        this.layout.m_264075_((LayoutElement)new Button.Builder((Component)Component.m_237113_((String)"Add"), b -> {
            this.universeConfigs.put(this.universeConfigs.size() + 1, (Object)new UniverseConfig(0, 0, false));
            this.refresh();
        }).m_252780_(150).m_253136_(), 4, 1, LayoutSettings.m_264214_().m_264311_(0).m_264356_());
        this.deleteConfig = new Button.Builder((Component)Component.m_237113_((String)"Delete"), b -> {
            if (this.configList.m_93511_() != null) {
                this.universeConfigs.remove(((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getNetworkUniverse());
                this.setSelected(null);
            }
            this.refresh();
        }).m_252780_(150).m_253136_();
        this.deleteConfig.f_93623_ = false;
        this.deleteConfig.f_93624_ = false;
        this.layout.m_264075_((LayoutElement)this.deleteConfig, 4, 3, LayoutSettings.m_264214_().m_264311_(0).m_264356_());
        this.networkUniverse = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 100, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.networkUniverse")).color(0xFFFFFF).textOffsetY(-5).shadow(true);
        this.networkUniverse.f_93624_ = false;
        this.networkUniverse.f_93623_ = false;
        this.layout.m_264379_((LayoutElement)this.networkUniverse, 2, 2);
        this.universeEnabled = new Checkbox(this.xCenter, this.yCenter, 150, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.networkEnabled"), false);
        this.universeEnabled.f_93624_ = false;
        this.universeEnabled.f_93623_ = false;
        this.layout.m_264379_((LayoutElement)this.universeEnabled, 2, 3);
        this.subnet = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 100, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.subnet")).color(0xFFFFFF).textOffsetY(-5).shadow(true);
        this.subnet.f_93624_ = false;
        this.subnet.f_93623_ = false;
        this.layout.m_264379_((LayoutElement)this.subnet, 3, 2);
        this.universe = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 100, 20, (Component)Component.m_237115_((String)"artneti.dmxUniverse")).color(0xFFFFFF).textOffsetY(-5).shadow(true);
        this.universe.f_93624_ = false;
        this.universe.f_93623_ = false;
        this.layout.m_264379_((LayoutElement)this.universe, 3, 3);
        this.layout.m_264379_((LayoutElement)new CycleButton.Builder(enabled -> Component.m_237110_((String)"screen.artnetconfig.enabled", (Object[])new Object[]{enabled != false ? "Yes" : "No"})).m_232502_(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).m_168929_().m_168948_((Object)this.enabled).m_168936_(this.xCenter, this.yCenter, 150, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.enabled"), (obj, val) -> {
            this.enabled = val;
        }), 5, 1);
        this.layout.m_264379_((LayoutElement)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.m_237113_((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.m_237113_((String)"Unknown");
        }).m_232500_(CycleButton.ValueListSupplier.m_232504_((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).m_168929_().m_168948_((Object)this.networkId).m_168936_(this.xCenter, this.yCenter, 150, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.enabled"), (obj, val) -> {
            this.networkId = val;
        }), 5, 3);
        this.layout.m_264379_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"artneti.save"), button -> this.update()).m_252794_(this.xCenter + 40, this.yCenter + 200).m_253046_(150, 20).m_253136_(), 6, 3);
        this.layout.m_264379_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"gui.back"), button -> this.f_96541_.m_91152_(this.lastScreen)).m_252794_(this.xCenter + 40, this.yCenter + 200).m_253046_(150, 20).m_253136_(), 6, 1);
        this.layout.m_264036_();
        this.m_267719_();
        this.m_142416_((GuiEventListener)this.configList);
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    protected void m_267719_() {
        FrameLayout.m_264460_((LayoutElement)this.layout, (int)0, (int)(this.f_96544_ / 6 - 12), (int)this.f_96543_, (int)this.f_96544_, (float)0.5f, (float)0.0f);
    }

    protected void refresh() {
        this.configList.setEntries((Map<Integer, UniverseConfig>)this.universeConfigs);
    }

    private void saveCurrentSelection() {
        if (this.configList.m_93511_() != null) {
            ((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getConfig().subnet = Integer.parseInt(this.subnet.m_94155_());
            ((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getConfig().universe = Integer.parseInt(this.universe.m_94155_());
            ((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getConfig().enabled = this.universeEnabled.m_93840_();
            if (((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getNetworkUniverse() != Integer.parseInt(this.networkUniverse.m_94155_())) {
                int oldAddress = ((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getNetworkUniverse();
                int newAddress = Integer.parseInt(this.networkUniverse.m_94155_());
                this.universeConfigs.put(newAddress, (Object)((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getConfig());
                this.universeConfigs.remove(oldAddress);
                this.refresh();
            } else {
                this.universeConfigs.put(((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getNetworkUniverse(), (Object)((ArtNetUniverseConfigurationList.Entry)this.configList.m_93511_()).getConfig());
            }
        }
    }

    public void setSelected(ArtNetUniverseConfigurationList.Entry entry) {
        if (entry != null) {
            this.saveCurrentSelection();
        }
        this.configList.m_6987_((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.networkUniverse.f_93624_ = true;
            this.networkUniverse.f_93623_ = true;
            this.networkUniverse.m_94144_(Integer.toString(entry.getNetworkUniverse()));
            this.universe.f_93624_ = true;
            this.universe.f_93623_ = true;
            this.universe.m_94144_(Integer.toString(entry.getConfig().getUniverse()));
            this.subnet.f_93624_ = true;
            this.subnet.f_93623_ = true;
            this.subnet.m_94144_(Integer.toString(entry.getConfig().getSubnet()));
            this.universeEnabled.f_93624_ = true;
            this.universeEnabled.f_93623_ = true;
            if (!this.universeEnabled.m_93840_() && entry.getConfig().isEnabled()) {
                this.universeEnabled.m_5691_();
            } else if (this.universeEnabled.m_93840_() && !entry.getConfig().isEnabled()) {
                this.universeEnabled.m_5691_();
            }
            this.deleteConfig.f_93623_ = true;
            this.deleteConfig.f_93624_ = true;
        } else {
            this.networkUniverse.f_93624_ = false;
            this.networkUniverse.f_93623_ = false;
            this.universe.f_93624_ = false;
            this.universe.f_93623_ = false;
            this.subnet.f_93624_ = false;
            this.subnet.f_93623_ = false;
            this.universeEnabled.f_93624_ = false;
            this.universeEnabled.f_93623_ = false;
            this.deleteConfig.f_93623_ = false;
            this.deleteConfig.f_93624_ = false;
        }
    }

    private void update() {
        try {
            boolean isInGame;
            this.saveCurrentSelection();
            boolean hasChangedIP = false;
            if (!Objects.equals(TheatricalConfig.INSTANCE.CLIENT.artNetIP, this.ipAddressBox.m_94155_()) && TheatricalConfig.INSTANCE.CLIENT.artNetIP != null) {
                hasChangedIP = true;
            }
            TheatricalConfig.INSTANCE.CLIENT.artNetIP = this.ipAddressBox.m_94155_();
            TheatricalConfig.INSTANCE.CLIENT.artnetEnabled = this.enabled;
            if (this.networkId != TheatricalClient.getArtNetManager().getNetworkId()) {
                TheatricalClient.getArtNetManager().setNetworkId(this.networkId);
            }
            TheatricalConfig.INSTANCE.CLIENT.universes = this.universeConfigs;
            ConfigHandler.INSTANCE.saveConfig(ConfigHandler.ConfigSide.CLIENT);
            boolean bl = isInGame = Minecraft.m_91087_().f_91073_ != null;
            if (isInGame) {
                if (!this.enabled) {
                    TheatricalClient.getArtNetManager().shutdownAll();
                } else {
                    if (hasChangedIP) {
                        TheatricalClient.getArtNetManager().shutdownAll();
                        TheatricalClient.getArtNetManager().getClient();
                    }
                    if (TheatricalClient.getArtNetManager().getClient() != null) {
                        TheatricalClient.getArtNetManager().getClient().refreshSubscriptions();
                    }
                }
            }
            this.f_96541_.m_91152_(this.lastScreen);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        if (TheatricalConfig.INSTANCE.CLIENT.artnetEnabled) {
            if (TheatricalClient.getArtNetManager().getClient() != null && TheatricalClient.getArtNetManager().getClient().hasReceivedPacket()) {
                long inSeconds = Math.round((float)(System.currentTimeMillis() - TheatricalClient.getArtNetManager().getClient().getLastPacketMS()) / 1000.0f);
                this.renderLabel(guiGraphics, "artneti.lastReceived", -50, this.ipAddressBox.m_252907_() + 5, inSeconds);
            } else {
                this.renderLabel(guiGraphics, "artneti.notConnected", -50, this.ipAddressBox.m_252907_() + 5, new Object[0]);
            }
        }
    }

    private void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY, Object ... replacements) {
        MutableComponent translatable = Component.m_237110_((String)translationKey, (Object[])replacements);
        guiGraphics.m_280614_(this.f_96547_, (Component)translatable, this.xCenter + this.f_96547_.m_92895_(translatable.getString()) / 2 + offSetX, offSetY, 0xFFFFFF, false);
    }

    public void m_86600_() {
    }
}

