/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.client.gui.widgets.LabeledEditBox;
import dev.imabad.theatrical.net.UpdateDMXFixture;
import dev.imabad.theatrical.net.UpdateNetworkId;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GenericDMXConfigurationScreen<T extends DMXConsumer>
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/blank.png");
    protected final int imageWidth;
    protected final int imageHeight;
    protected int xCenter;
    protected int yCenter;
    private LabeledEditBox dmxAddress;
    private LabeledEditBox dmxUniverse;
    private UUID networkId = UUIDUtil.NULL;
    private final T be;
    private final BlockPos blockPos;
    private final String titleTranslationKey;
    protected LinearLayout layout;

    public GenericDMXConfigurationScreen(T be, BlockPos pos, String titleTranslationKey) {
        super((Component)Component.m_237115_((String)titleTranslationKey));
        this.imageWidth = 176;
        this.imageHeight = 126;
        this.be = be;
        this.blockPos = pos;
        this.titleTranslationKey = titleTranslationKey;
        this.networkId = be.getNetworkId();
    }

    public void addExtraWidgetsToUI() {
    }

    protected void m_7856_() {
        super.m_7856_();
        this.layout = new LinearLayout(this.imageWidth, 176, LinearLayout.Orientation.VERTICAL);
        this.layout.m_264286_().m_264356_().m_264174_(10);
        this.dmxAddress = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 50, 10, (Component)Component.m_237115_((String)"fixture.dmxStart"));
        this.dmxAddress.m_94144_(Integer.toString(this.be.getChannelStart()));
        this.layout.m_264406_((LayoutElement)this.dmxAddress);
        this.dmxUniverse = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 50, 10, (Component)Component.m_237115_((String)"artneti.dmxUniverse"));
        this.dmxUniverse.m_94144_(Integer.toString(this.be.getUniverse()));
        this.layout.m_264406_((LayoutElement)this.dmxUniverse);
        this.addExtraWidgetsToUI();
        this.layout.m_264406_((LayoutElement)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.m_237113_((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.m_237113_((String)"Unknown");
        }).m_232500_(CycleButton.ValueListSupplier.m_232504_((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).m_168929_().m_168948_((Object)this.networkId).m_168936_(this.xCenter, this.yCenter, 150, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.network"), (obj, val) -> {
            this.networkId = val;
        }));
        this.layout.m_264406_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"artneti.save"), button -> this.update()).m_252794_(this.xCenter, this.yCenter).m_253046_(100, 20).m_253136_());
        this.refreshLayout();
        this.m_267719_();
    }

    protected void refreshLayout() {
        if (this.layout == null) {
            return;
        }
        this.layout.m_264036_();
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    protected void m_267719_() {
        FrameLayout.m_267781_((LayoutElement)this.layout, (ScreenRectangle)this.m_264198_());
    }

    protected void update() {
        try {
            int dmx = Integer.parseInt(this.dmxAddress.m_94155_());
            if (dmx > 512 || dmx < 0) {
                return;
            }
            int universe = Integer.parseInt(this.dmxUniverse.m_94155_());
            if (universe < 0) {
                return;
            }
            new UpdateDMXFixture(this.blockPos, dmx, universe).sendToServer();
            new UpdateNetworkId(this.blockPos, this.networkId).sendToServer();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        this.renderWindow(guiGraphics);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int layoutHeight = 0;
        if (this.layout != null) {
            layoutHeight = this.layout.m_93694_();
        }
        int relX = (this.f_96543_ - this.imageWidth) / 2;
        int relY = (this.f_96544_ - layoutHeight) / 2;
        guiGraphics.m_280411_(this.GUI, relX, relY, this.imageWidth, layoutHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics) {
    }

    protected void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY) {
        MutableComponent translatable = Component.m_237115_((String)translationKey);
        guiGraphics.m_280614_(this.f_96547_, (Component)translatable, this.xCenter + this.imageWidth / 2 - this.f_96547_.m_92895_(translatable.getString()) / 2, this.yCenter + offSetY, 0x404040, false);
    }

    public boolean m_7043_() {
        return false;
    }
}

