/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.imabad.theatrical.commands.DMXNetworkModeArgument;
import dev.imabad.theatrical.commands.MemberRoleArgument;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.dmx.DMXNetworkMember;
import dev.imabad.theatrical.dmx.DMXNetworkMemberRole;
import dev.imabad.theatrical.dmx.DMXNetworkMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class NetworkCommand {
    private static final SimpleCommandExceptionType ERROR_NETWORK_DOES_NOT_EXIST = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.network.notfound"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"theatrical").then(Commands.m_82127_((String)"networks").executes(NetworkCommand::listNetworks))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"network").then(Commands.m_82127_((String)"new").then(Commands.m_82129_((String)"mode", (ArgumentType)DMXNetworkModeArgument.networkMode()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(NetworkCommand::createNetwork))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.m_82981_(NetworkCommand.getNetworksForPlayer((CommandContext<CommandSourceStack>)commandContext).stream().map(serverPlayer -> serverPlayer.id().toString()), (SuggestionsBuilder)suggestionsBuilder)).executes(NetworkCommand::getNetwork)).then(Commands.m_82127_((String)"members").executes(NetworkCommand::listNetworkMembers))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(NetworkCommand::renameNetwork)))).then(Commands.m_82127_((String)"delete").executes(NetworkCommand::deleteNetwork))).then(Commands.m_82127_((String)"mode").then(Commands.m_82129_((String)"mode", (ArgumentType)DMXNetworkModeArgument.networkMode()).executes(NetworkCommand::changeNetworkMode)))).then(Commands.m_82127_((String)"setrole").then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).suggests((commandContext, suggestionsBuilder) -> {
            Set<DMXNetworkMember> members = NetworkCommand.getDMXNetwork((CommandContext<CommandSourceStack>)commandContext).members();
            GameProfileCache profileCache = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129927_();
            return SharedSuggestionProvider.m_82981_(members.stream().map(serverPlayer -> profileCache.m_11002_(serverPlayer.playerId()).orElse(new GameProfile(serverPlayer.playerId(), serverPlayer.playerId().toString())).getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).then(Commands.m_82129_((String)"role", (ArgumentType)MemberRoleArgument.memberRole()).executes(NetworkCommand::changeMemberRole))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).suggests((commandContext, suggestionsBuilder) -> {
            PlayerList playerList = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_6846_();
            return SharedSuggestionProvider.m_82981_(playerList.m_11314_().stream().map(serverPlayer -> serverPlayer.m_36316_().getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(NetworkCommand::addPlayer)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)GameProfileArgument.m_94584_()).suggests((commandContext, suggestionsBuilder) -> {
            Set<DMXNetworkMember> members = NetworkCommand.getDMXNetwork((CommandContext<CommandSourceStack>)commandContext).members();
            GameProfileCache profileCache = ((CommandSourceStack)commandContext.getSource()).m_81377_().m_129927_();
            return SharedSuggestionProvider.m_82981_(members.stream().map(serverPlayer -> profileCache.m_11002_(serverPlayer.playerId()).orElse(new GameProfile(serverPlayer.playerId(), serverPlayer.playerId().toString())).getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(NetworkCommand::removePlayer))))));
    }

    private static int changeMemberRole(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        Collection players = GameProfileArgument.m_94590_(context, (String)"target");
        DMXNetworkMemberRole role = MemberRoleArgument.getMode(context, "role");
        for (GameProfile player : players) {
            dmxNetwork.setMemberRole(player.getId(), role);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.network.updated"), false);
        return 0;
    }

    private static int changeNetworkMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        DMXNetworkMode mode = DMXNetworkModeArgument.getMode(context, "mode");
        DMXNetworkMode oldMode = dmxNetwork.mode();
        dmxNetwork.setMode(mode);
        ArrayList<UUID> members = new ArrayList<UUID>();
        for (DMXNetworkMember member : dmxNetwork.members()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(member.playerId());
            if (player == null) continue;
            DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).notifyNetworks((Player)player);
            members.add(player.m_20148_());
        }
        if (dmxNetwork.mode() == DMXNetworkMode.PUBLIC || oldMode == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                if (members.contains(player.m_20148_())) continue;
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).notifyNetworks((Player)player);
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.network.updated"), false);
        return 1;
    }

    private static int createNetwork(CommandContext<CommandSourceStack> context) {
        String newName = StringArgumentType.getString(context, (String)"name");
        DMXNetworkMode mode = DMXNetworkModeArgument.getMode(context, "mode");
        DMXNetwork network = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).createNetwork(newName, mode);
        if (((CommandSourceStack)context.getSource()).m_230897_()) {
            network.addMember(((CommandSourceStack)context.getSource()).m_230896_().m_20148_(), DMXNetworkMemberRole.ADMIN);
        }
        if (network.mode() == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).notifyNetworks((Player)player);
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.network.created"), false);
        return 1;
    }

    private static int listNetworkMembers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        GameProfileCache profileCache = ((CommandSourceStack)context.getSource()).m_81377_().m_129927_();
        List<String> list = dmxNetwork.members().stream().map(DMXNetworkMember::playerId).map(playerUUID -> new Tuple(playerUUID, (Object)profileCache.m_11002_(playerUUID))).map(uuidOptionalTuple -> ((Optional)uuidOptionalTuple.m_14419_()).isPresent() ? ((GameProfile)((Optional)uuidOptionalTuple.m_14419_()).get()).getName() : ((UUID)uuidOptionalTuple.m_14418_()).toString()).toList();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.network.members", (Object[])new Object[]{list.size(), String.join((CharSequence)", ", list)}), false);
        return 1;
    }

    private static int getNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        int i = 0;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.network", (Object[])new Object[]{Component.m_237113_((String)dmxNetwork.name()), dmxNetwork.id().toString(), dmxNetwork.members().size()}), false);
        return i;
    }

    private static int addPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        int i = 0;
        Collection players = GameProfileArgument.m_94590_(context, (String)"targets");
        for (GameProfile player : players) {
            if (dmxNetwork.isMember(player.getId())) continue;
            dmxNetwork.addMember(player.getId(), DMXNetworkMemberRole.NONE);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.network.members.add.success", (Object[])new Object[]{Component.m_237113_((String)player.getName())}), false);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(player.getId());
            if (serverPlayer != null) {
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).notifyNetworks((Player)serverPlayer);
            }
            ++i;
        }
        return i;
    }

    private static int renameNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        String newName = StringArgumentType.getString(context, (String)"name");
        dmxNetwork.setName(newName);
        ArrayList<UUID> members = new ArrayList<UUID>();
        for (DMXNetworkMember member : dmxNetwork.members()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(member.playerId());
            if (player == null) continue;
            DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).notifyNetworks((Player)player);
            members.add(player.m_20148_());
        }
        if (dmxNetwork.mode() == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                if (members.contains(player.m_20148_())) continue;
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).notifyNetworks((Player)player);
            }
        }
        return 1;
    }

    private static int deleteNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).deleteNetwork(dmxNetwork);
        ArrayList<UUID> members = new ArrayList<UUID>();
        for (DMXNetworkMember member : dmxNetwork.members()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(member.playerId());
            if (player == null) continue;
            DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).notifyNetworks((Player)player);
            members.add(player.m_20148_());
        }
        if (dmxNetwork.mode() == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                if (members.contains(player.m_20148_())) continue;
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_()).notifyNetworks((Player)player);
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.network.deleted"), false);
        return 1;
    }

    private static int removePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).m_230897_() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).m_230896_().m_20148_())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        Collection players = GameProfileArgument.m_94590_(context, (String)"targets");
        for (GameProfile player : players) {
            if (!dmxNetwork.isMember(player.getId())) continue;
            dmxNetwork.removeMember(player.getId());
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(player.getId());
            if (serverPlayer != null) {
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).notifyNetworks((Player)serverPlayer);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.network.members.remove.success", (Object[])new Object[]{Component.m_237113_((String)player.getName())}), false);
        }
        return 0;
    }

    private static Collection<DMXNetwork> getNetworksForPlayer(CommandContext<CommandSourceStack> context) {
        DMXNetworkData instance = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_());
        if (NetworkCommand.isSourceOperator(context)) {
            return instance.getAllNetworks();
        }
        return instance.getNetworksForPlayer(((CommandSourceStack)context.getSource()).m_230896_().m_20148_());
    }

    private static int listNetworks(CommandContext<CommandSourceStack> context) {
        DMXNetworkData instance = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_());
        List networks = NetworkCommand.isSourceOperator(context) ? instance.getAllNetworks().stream().map(DMXNetwork::name).collect(Collectors.toList()) : instance.getNetworksForPlayer(((CommandSourceStack)context.getSource()).m_230896_().m_20148_()).stream().map(DMXNetwork::name).collect(Collectors.toList());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.networks", (Object[])new Object[]{networks.size(), String.join((CharSequence)", ", networks)}), false);
        return 1;
    }

    private static boolean isSourceOperator(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).m_6761_(((CommandSourceStack)context.getSource()).m_81377_().m_7022_());
    }

    private static DMXNetwork getDMXNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetworkData instance = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).m_81377_().m_129783_());
        try {
            String id = (String)context.getArgument("id", String.class);
            UUID uuid = UUID.fromString(id);
            DMXNetwork network = instance.getNetwork(uuid);
            if (network != null) {
                return network;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw ERROR_NETWORK_DOES_NOT_EXIST.create();
    }
}

