/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.config;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.config.BaseConfig;
import dev.imabad.theatrical.config.UniverseConfig;
import dev.imabad.theatrical.config.api.TheatricalConfigItem;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigHandler {
    public static ConfigHandler INSTANCE;
    private final Path configFolder;
    private final Yaml yaml;
    private final Map<ResourceLocation, BaseConfig> registered_configs = new HashMap<ResourceLocation, BaseConfig>();

    public static ConfigHandler initialize(Path configFolder) {
        INSTANCE = new ConfigHandler(configFolder);
        return INSTANCE;
    }

    private ConfigHandler(Path configFolder) {
        this.configFolder = configFolder;
        File file = this.configFolder.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        LoaderOptions loaderOptions = new LoaderOptions();
        TagInspector taginspector = tag -> tag.getClassName().equals(UniverseConfig.class.getName());
        loaderOptions.setTagInspector(taginspector);
        this.yaml = new Yaml((BaseConstructor)new Constructor(loaderOptions), new Representer(options));
    }

    @Nullable
    public <T extends BaseConfig> T registerConfig(String modID, ConfigSide side, Supplier<T> configCreator) {
        if (Platform.getEnvironment() == Env.SERVER && side == ConfigSide.COMMON || Platform.getEnvironment() == Env.CLIENT) {
            File sideConfig = Paths.get(this.configFolder.toString(), modID + "-" + side.name().toLowerCase(Locale.ENGLISH) + ".yml").toFile();
            BaseConfig config = (BaseConfig)configCreator.get();
            if (sideConfig.exists()) {
                this.load(config, sideConfig);
            } else {
                this.save(config, sideConfig);
            }
            ResourceLocation location = new ResourceLocation(modID, side.name().toLowerCase(Locale.ENGLISH));
            this.registered_configs.put(location, config);
            return (T)config;
        }
        return null;
    }

    public void saveConfig(ConfigSide configSide) {
        ResourceLocation resourceLocation = new ResourceLocation("theatrical", configSide.name().toLowerCase(Locale.ENGLISH));
        File sideConfig = Paths.get(this.configFolder.toString(), "theatrical-" + configSide.name().toLowerCase(Locale.ENGLISH) + ".yml").toFile();
        this.save(this.registered_configs.get(resourceLocation), sideConfig);
    }

    private <T> void save(T config, File output) {
        HashMap<String, Object> yamlMap = new HashMap<String, Object>();
        this.magicWrite(config, yamlMap);
        try {
            this.yaml.dump(yamlMap, (Writer)new FileWriter(output));
        }
        catch (Exception e) {
            Theatrical.LOGGER.atError().setCause((Throwable)e).setMessage("Error saving config {} to {}").addArgument(() -> config.getClass().getSimpleName()).addArgument((Object)output).log();
        }
    }

    private <T> void load(T config, File input) {
        try {
            Map parsedYaml = (Map)this.yaml.load((Reader)new FileReader(input.getPath()));
            this.magicLoad(config, parsedYaml);
        }
        catch (Exception e) {
            Theatrical.LOGGER.atError().setCause((Throwable)e).setMessage("Error loading config {} from {}").addArgument(() -> config.getClass().getSimpleName()).addArgument((Object)input).log();
        }
    }

    private <T> void magicLoad(T config, Map<String, Object> inputMap) {
        Field[] fields = config.getClass().getFields();
        Set<String> incomingStrings = inputMap.keySet();
        for (Field f : fields) {
            Class<?> fieldType;
            if (!f.isAnnotationPresent(TheatricalConfigItem.class)) continue;
            TheatricalConfigItem annotation = f.getAnnotation(TheatricalConfigItem.class);
            String fieldName = annotation.name().length > 0 ? annotation.name()[0] : f.getName();
            Class<?> clazz = fieldType = annotation.type().length > 0 ? annotation.type()[0] : f.getType();
            if (!incomingStrings.contains(fieldName)) break;
            Object value = inputMap.get(fieldName);
            if ((annotation.maxValue().length > 0 || annotation.minValue().length > 0) && fieldType.isPrimitive() && value instanceof Number) {
                Number number = (Number)value;
                if (annotation.maxValue().length > 0 && number.doubleValue() > Double.parseDouble(annotation.maxValue()[0])) {
                    Theatrical.LOGGER.atError().setMessage("Config '{}' value '{}' is larger than the max '{}'").addArgument((Object)fieldName).addArgument((Object)number).addArgument(() -> annotation.maxValue()[0]).log();
                    break;
                }
                if (annotation.minValue().length > 0 && number.doubleValue() < Double.parseDouble(annotation.minValue()[0])) {
                    Theatrical.LOGGER.atError().setMessage("Config '{}' value '{}' is smaller than the min '{}'").addArgument((Object)fieldName).addArgument((Object)number).addArgument(() -> annotation.minValue()[0]).log();
                    break;
                }
            }
            try {
                f.set(config, value);
            }
            catch (IllegalAccessException e) {
                Theatrical.LOGGER.atError().setCause((Throwable)e).setMessage("Error updating config field '{}' with value '{}'").addArgument((Object)fieldName).addArgument(value).log();
            }
        }
    }

    private <T> void magicWrite(T config, Map<String, Object> outputMap) {
        Field[] fields;
        for (Field f : fields = config.getClass().getFields()) {
            if (!f.isAnnotationPresent(TheatricalConfigItem.class)) continue;
            TheatricalConfigItem annotation = f.getAnnotation(TheatricalConfigItem.class);
            String fieldName = annotation.name().length > 0 ? annotation.name()[0] : f.getName();
            try {
                outputMap.put(fieldName, f.get(config));
            }
            catch (IllegalAccessException e) {
                Theatrical.LOGGER.atError().setCause((Throwable)e).setMessage("Error getting config field '{}'").addArgument((Object)fieldName).log();
            }
        }
    }

    public static enum ConfigSide {
        COMMON,
        CLIENT;

    }
}

