/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.config;

import dev.imabad.theatrical.config.BaseConfig;
import dev.imabad.theatrical.config.ConfigHandler;
import dev.imabad.theatrical.config.UniverseConfig;
import dev.imabad.theatrical.config.api.TheatricalConfigItem;
import io.netty.util.collection.IntObjectHashMap;
import java.util.Map;

public class TheatricalConfig {
    public static TheatricalConfig INSTANCE = new TheatricalConfig();
    public ClientConfig CLIENT;
    public ServerConfig COMMON;

    public void register(ConfigHandler handler) {
        this.CLIENT = handler.registerConfig("theatrical", ConfigHandler.ConfigSide.CLIENT, ClientConfig::new);
        this.COMMON = handler.registerConfig("theatrical", ConfigHandler.ConfigSide.COMMON, ServerConfig::new);
    }

    public static class ClientConfig
    extends BaseConfig {
        @TheatricalConfigItem(minValue={"0"}, maxValue={"1"})
        public double beamOpacity = 0.4;
        @TheatricalConfigItem(minValue={"0"})
        public int renderDistance = 64;
        @TheatricalConfigItem
        public boolean doOwnerCheck = true;
        @TheatricalConfigItem
        public boolean artnetEnabled = false;
        @TheatricalConfigItem
        public String artNetIP = "";
        @TheatricalConfigItem
        public Map<Integer, UniverseConfig> universes = new IntObjectHashMap();
    }

    public static class ServerConfig
    extends BaseConfig {
        @TheatricalConfigItem
        public boolean shouldEmitLight = true;
        @TheatricalConfigItem(minValue={"0"})
        public int wirelessDMXRadius = 40;
        @TheatricalConfigItem(minValue={"25"})
        public int defaultMaxLightDist = 25;
        @TheatricalConfigItem(minValue={"0"})
        public double maxLightDistance = 7.75;
        private double maxLightDistanceSquared = -1.0;

        public double getMaxLightDistanceSquared() {
            if (this.maxLightDistanceSquared == -1.0) {
                this.maxLightDistanceSquared = this.maxLightDistance * this.maxLightDistance;
            }
            return this.maxLightDistanceSquared;
        }
    }
}

