/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.dmx;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.dmx.DMXDevice;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.dmx.DMXNetworkMember;
import dev.imabad.theatrical.dmx.DMXNetworkMemberRole;
import dev.imabad.theatrical.dmx.DMXNetworkMode;
import dev.imabad.theatrical.net.artnet.NotifyConsumerChange;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class DMXNetwork {
    private final UUID id;
    private String name;
    private DMXNetworkMode mode;
    private final Set<DMXNetworkMember> members;
    private final IntObjectMap<Map<BlockPos, DMXConsumer>> universeToNodeMap = new IntObjectHashMap();
    private final Set<ServerPlayer> knownSenders = new HashSet<ServerPlayer>();

    public DMXNetwork(UUID id, String name, DMXNetworkMode mode, Set<DMXNetworkMember> members) {
        this.id = id;
        this.name = name;
        this.mode = mode;
        this.members = members;
    }

    public DMXNetwork(CompoundTag data) {
        this.id = data.m_128342_("id");
        this.name = data.m_128461_("name");
        this.mode = DMXNetworkMode.valueOf(data.m_128461_("mode"));
        this.members = new HashSet<DMXNetworkMember>();
        ListTag membersList = data.m_128437_("members", 10);
        for (Tag tag : membersList) {
            CompoundTag member = (CompoundTag)tag;
            UUID player = member.m_128342_("player");
            DMXNetworkMemberRole role = DMXNetworkMemberRole.valueOf(member.m_128461_("role"));
            this.members.add(new DMXNetworkMember(player, role));
        }
    }

    public DMXNetwork(String name) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.mode = DMXNetworkMode.PRIVATE;
        this.members = new HashSet<DMXNetworkMember>();
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", this.id);
        tag.m_128359_("mode", this.mode.toString());
        tag.m_128359_("name", this.name);
        ListTag membersList = new ListTag();
        for (DMXNetworkMember member : this.members) {
            CompoundTag memberTag = new CompoundTag();
            memberTag.m_128362_("player", member.playerId());
            memberTag.m_128359_("role", member.role().toString());
            membersList.add((Object)memberTag);
        }
        tag.m_128365_("members", (Tag)membersList);
        return tag;
    }

    public String name() {
        return this.name;
    }

    public UUID id() {
        return this.id;
    }

    public DMXNetworkMode mode() {
        return this.mode;
    }

    public Set<DMXNetworkMember> members() {
        return this.members;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DMXNetwork that = (DMXNetwork)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "DMXNetwork[id=" + String.valueOf(this.id) + ", mode=" + String.valueOf((Object)this.mode) + ", members=" + String.valueOf(this.members) + "]";
    }

    public void addConsumer(BlockPos pos, DMXConsumer consumer) {
        Map universe = (Map)this.universeToNodeMap.computeIfAbsent((Object)consumer.getUniverse(), uni -> new ConcurrentHashMap());
        universe.put(pos, consumer);
        this.universeToNodeMap.put(consumer.getUniverse(), (Object)universe);
        new NotifyConsumerChange(consumer.getUniverse(), NotifyConsumerChange.ChangeType.ADD, new DMXDevice(consumer.getDeviceId(), consumer.getChannelStart(), consumer.getChannelCount(), consumer.getDeviceTypeId(), consumer.getActivePersonality(), consumer.getModelName(), consumer.getFixtureId())).sendTo(this.knownSenders);
    }

    public void updateConsumer(DMXConsumer consumer) {
        new NotifyConsumerChange(consumer.getUniverse(), NotifyConsumerChange.ChangeType.UPDATE, new DMXDevice(consumer.getDeviceId(), consumer.getChannelStart(), consumer.getChannelCount(), consumer.getDeviceTypeId(), consumer.getActivePersonality(), consumer.getModelName(), consumer.getFixtureId())).sendTo(this.knownSenders);
    }

    public void removeConsumer(DMXConsumer consumer, BlockPos pos) {
        if (!this.universeToNodeMap.containsKey(consumer.getUniverse())) {
            return;
        }
        Map universe = (Map)this.universeToNodeMap.get(consumer.getUniverse());
        universe.remove(pos);
        new NotifyConsumerChange(consumer.getUniverse(), NotifyConsumerChange.ChangeType.REMOVE, new DMXDevice(consumer.getDeviceId(), 0, 0, 0, 0, "", new ResourceLocation(""))).sendTo(this.knownSenders);
    }

    @Nullable
    public Collection<DMXConsumer> getConsumers(int universe) {
        if (this.universeToNodeMap.get(universe) != null) {
            return ((Map)this.universeToNodeMap.get(universe)).values();
        }
        return null;
    }

    public BlockPos getConsumerPos(int universe, RDMDeviceId deviceId) {
        for (Map.Entry blockPosDMXConsumerEntry : ((Map)this.universeToNodeMap.get(universe)).entrySet()) {
            if (!((DMXConsumer)blockPosDMXConsumerEntry.getValue()).getDeviceId().equals((Object)deviceId)) continue;
            return (BlockPos)blockPosDMXConsumerEntry.getKey();
        }
        return null;
    }

    public Collection<DMXConsumer> getConsumersInRange(int universe, BlockPos fromPos, int radius) {
        HashSet<DMXConsumer> consumers = new HashSet<DMXConsumer>();
        if (!this.universeToNodeMap.containsKey(universe) || ((Map)this.universeToNodeMap.get(universe)).isEmpty()) {
            return consumers;
        }
        for (Map.Entry entry : ((Map)this.universeToNodeMap.get(universe)).entrySet()) {
            if (!(Math.sqrt(fromPos.m_203198_((double)((BlockPos)entry.getKey()).m_123341_(), (double)((BlockPos)entry.getKey()).m_123342_(), (double)((BlockPos)entry.getKey()).m_123343_())) <= (double)radius)) continue;
            consumers.add((DMXConsumer)entry.getValue());
        }
        return consumers;
    }

    public Set<Integer> getUniverses() {
        return this.universeToNodeMap.keySet();
    }

    public void addMember(UUID playerUUID, DMXNetworkMemberRole role) {
        this.members.add(new DMXNetworkMember(playerUUID, role));
        DMXNetworkData.getInstance().m_77762_();
    }

    public void removeMember(UUID playerUUID) {
        DMXNetworkMember dmxNetworkMember = this.getDmxNetworkMember(playerUUID);
        this.members.remove(dmxNetworkMember);
        DMXNetworkData.getInstance().m_77762_();
    }

    public boolean isMember(UUID playerUUID) {
        return this.members.stream().anyMatch(x -> x.playerId().equals(playerUUID));
    }

    public boolean canSendDMX(UUID uuid) {
        DMXNetworkMember dmxNetworkMember = this.getDmxNetworkMember(uuid);
        if (dmxNetworkMember == null) {
            return false;
        }
        return dmxNetworkMember.role() == DMXNetworkMemberRole.SEND || dmxNetworkMember.role() == DMXNetworkMemberRole.ADMIN;
    }

    public boolean isAdmin(UUID uuid) {
        DMXNetworkMember dmxNetworkMember = this.getDmxNetworkMember(uuid);
        if (dmxNetworkMember == null) {
            return false;
        }
        return dmxNetworkMember.role() == DMXNetworkMemberRole.ADMIN;
    }

    public void setMemberRole(UUID playerId, DMXNetworkMemberRole role) {
        DMXNetworkMember dmxNetworkMember = this.getDmxNetworkMember(playerId);
        if (dmxNetworkMember != null) {
            dmxNetworkMember.setRole(role);
            DMXNetworkData.getInstance().m_77762_();
        }
    }

    @Nullable
    private DMXNetworkMember getDmxNetworkMember(UUID uuid) {
        Optional<DMXNetworkMember> first = this.members.stream().filter(dmxNetworkMember -> dmxNetworkMember.playerId().equals(uuid)).findFirst();
        return first.orElse(null);
    }

    public void setName(String name) {
        this.name = name;
        DMXNetworkData.getInstance().m_77762_();
    }

    public void setMode(DMXNetworkMode mode) {
        this.mode = mode;
        DMXNetworkData.getInstance().m_77762_();
    }
}

