/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.dmx;

import dev.architectury.utils.GameInstance;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkMemberRole;
import dev.imabad.theatrical.dmx.DMXNetworkMode;
import dev.imabad.theatrical.net.artnet.NotifyNetworks;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class DMXNetworkData
extends SavedData {
    private final Set<ServerPlayer> knownSenders = new HashSet<ServerPlayer>();
    private final Map<UUID, DMXNetwork> networks = new HashMap<UUID, DMXNetwork>();
    private static final String KEY = "dmx_networks";
    private static DMXNetworkData INSTANCE;

    public static void unloadLevel() {
        INSTANCE = null;
    }

    public static DMXNetworkData getInstance(Level level) {
        if (INSTANCE == null) {
            INSTANCE = (DMXNetworkData)level.m_7654_().m_129783_().m_8895_().m_164861_(DMXNetworkData::read, DMXNetworkData::new, KEY);
        }
        return INSTANCE;
    }

    public static DMXNetworkData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = (DMXNetworkData)GameInstance.getServer().m_129783_().m_8895_().m_164861_(DMXNetworkData::read, DMXNetworkData::new, KEY);
        }
        return INSTANCE;
    }

    @Nullable
    public DMXNetwork getNetwork(UUID networkId) {
        return this.networks.get(networkId);
    }

    public DMXNetwork createNetwork(Player player) {
        DMXNetwork network = new DMXNetwork(player.m_7755_().getString() + "'s Network");
        network.addMember(player.m_20148_(), DMXNetworkMemberRole.ADMIN);
        this.networks.put(network.id(), network);
        this.notifyNetworks(player);
        this.m_77762_();
        return network;
    }

    public DMXNetwork createNetwork(String name, DMXNetworkMode mode) {
        DMXNetwork network = new DMXNetwork(name);
        network.setMode(mode);
        this.networks.put(network.id(), network);
        this.m_77762_();
        return network;
    }

    public void deleteNetwork(DMXNetwork dmxNetwork) {
        this.networks.remove(dmxNetwork.id());
        this.m_77762_();
    }

    public void notifyNetworks(Player player) {
        Map<UUID, String> collect = this.getNetworksForPlayer(player.m_20148_()).stream().collect(Collectors.toMap(DMXNetwork::id, DMXNetwork::name));
        new NotifyNetworks(collect).sendTo((ServerPlayer)player);
    }

    public List<DMXNetwork> getNetworksForPlayer(UUID player) {
        return this.networks.values().stream().filter(dmxNetwork -> dmxNetwork.mode() == DMXNetworkMode.PUBLIC || dmxNetwork.isMember(player)).collect(Collectors.toList());
    }

    public Collection<DMXNetwork> getAllNetworks() {
        return this.networks.values();
    }

    public DMXNetwork getDefaultNetworkForPlayer(Player player) {
        UUID uuid = player.m_20148_();
        Optional<DMXNetwork> first = this.networks.values().stream().filter(dmxNetwork -> dmxNetwork.isMember(uuid)).findFirst();
        return first.orElseGet(() -> this.createNetwork(player));
    }

    public static DMXNetworkData read(CompoundTag tag) {
        DMXNetworkData data = new DMXNetworkData();
        ListTag networksTag = tag.m_128437_("networks", 10);
        for (Tag networkTag : networksTag) {
            DMXNetwork network = new DMXNetwork((CompoundTag)networkTag);
            data.networks.put(network.id(), network);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag networksTag = new ListTag();
        for (DMXNetwork value : this.networks.values()) {
            networksTag.add((Object)value.save());
        }
        compoundTag.m_128365_("networks", (Tag)networksTag);
        return compoundTag;
    }
}

