/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.fixtures;

import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.api.HangType;
import dev.imabad.theatrical.api.dmx.DMXPersonality;
import dev.imabad.theatrical.blocks.light.BaseLightBlock;
import dev.imabad.theatrical.fixtures.SharedSlots;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MovingLightFixture
extends Fixture {
    private static final List<DMXPersonality> PERSONALITIES = Collections.singletonList(new DMXPersonality(7, "7-Channel Mode").addSlot(SharedSlots.INTENSITY).addSlot(SharedSlots.RED).addSlot(SharedSlots.GREEN).addSlot(SharedSlots.BLUE).addSlot(SharedSlots.FOCUS).addSlot(SharedSlots.PAN).addSlot(SharedSlots.TILT));
    private static final ResourceLocation TILT_MODEL = new ResourceLocation("theatrical", "block/moving_light/moving_head_tilt");
    private static final ResourceLocation PAN_MODEL = new ResourceLocation("theatrical", "block/moving_light/moving_head_pan");
    private static final ResourceLocation STATIC_MODEL = new ResourceLocation("theatrical", "block/moving_light/moving_head_static");
    private final float[] tiltRotation = new float[]{0.5f, 0.5f, 0.5f};
    private final float[] panRotation = new float[]{0.5f, 0.5f, 0.5f};

    @Override
    public ResourceLocation getTiltModel() {
        return TILT_MODEL;
    }

    @Override
    public ResourceLocation getPanModel() {
        return PAN_MODEL;
    }

    @Override
    public ResourceLocation getStaticModel() {
        return STATIC_MODEL;
    }

    @Override
    public float[] getTiltRotationPosition() {
        return this.tiltRotation;
    }

    @Override
    public float[] getPanRotationPosition() {
        return this.panRotation;
    }

    @Override
    public float[] getBeamStartPosition() {
        return new float[]{0.5f, 0.5f, 0.2f};
    }

    @Override
    public float getDefaultRotation() {
        return 90.0f;
    }

    @Override
    public float getBeamWidth() {
        return 0.15f;
    }

    @Override
    public float getRayTraceRotation() {
        return 0.0f;
    }

    @Override
    public HangType getHangType() {
        return HangType.BRACE_BAR;
    }

    @Override
    public float[] getTransforms(BlockState fixtureBlockState, BlockState supportBlockState) {
        if (fixtureBlockState.m_61143_((Property)BaseLightBlock.HANG_DIRECTION) == Direction.UP) {
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        return new float[]{0.0f, -0.35f, 0.0f};
    }

    @Override
    public List<DMXPersonality> getDMXPersonalities() {
        return PERSONALITIES;
    }

    @Override
    public double getLightRadius() {
        return 8.5;
    }
}

