/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.forge;

import dev.architectury.platform.forge.EventBuses;
import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.fixtures.Fixtures;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="theatrical")
public class TheatricalForge {
    public TheatricalForge() {
        EventBuses.registerModEventBus((String)"theatrical", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClient);
        Theatrical.init();
    }

    public void onClient(FMLClientSetupEvent event) {
        TheatricalClient.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(additionalEvent -> {
            for (Fixture fixture : Fixtures.FIXTURES) {
                if (fixture.getStaticModel() != null) {
                    additionalEvent.register(fixture.getStaticModel());
                }
                if (fixture.hasPanModel() && fixture.getPanModel() != null) {
                    additionalEvent.register(fixture.getPanModel());
                }
                if (!fixture.hasTiltModel() || fixture.getTiltModel() == null) continue;
                additionalEvent.register(fixture.getTiltModel());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(renderLevelStageEvent -> {
            if (renderLevelStageEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                TheatricalClient.renderWorldLastAfterTripwire(renderLevelStageEvent.getLevelRenderer());
            }
            if (renderLevelStageEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                TheatricalClient.renderWorldLast(renderLevelStageEvent.getPoseStack(), renderLevelStageEvent.getProjectionMatrix(), renderLevelStageEvent.getCamera(), renderLevelStageEvent.getPartialTick());
            }
        });
    }
}

