/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.items.Items;
import dev.imabad.theatrical.net.TheatricalNet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ConfigureConfigurationCard
extends BaseC2SMessage {
    private UUID network;
    private int dmxAddress;
    private int dmxUniverse;
    private boolean autoIncrement;
    private boolean universeEnabled;
    private boolean addressEnabled;

    public ConfigureConfigurationCard(UUID network, int dmxAddress, int dmxUniverse, boolean autoIncrement, boolean universeEnabled, boolean addressEnabled) {
        this.network = network;
        this.dmxAddress = dmxAddress;
        this.dmxUniverse = dmxUniverse;
        this.autoIncrement = autoIncrement;
        this.universeEnabled = universeEnabled;
        this.addressEnabled = addressEnabled;
    }

    public ConfigureConfigurationCard(FriendlyByteBuf buf) {
        this.network = buf.m_130259_();
        this.dmxAddress = buf.readInt();
        this.dmxUniverse = buf.readInt();
        this.autoIncrement = buf.readBoolean();
        this.universeEnabled = buf.readBoolean();
        this.addressEnabled = buf.readBoolean();
    }

    public MessageType getType() {
        return TheatricalNet.CONFIGURE_CONFIGURATION_CARD;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.network);
        buf.writeInt(this.dmxAddress);
        buf.writeInt(this.dmxUniverse);
        buf.writeBoolean(this.autoIncrement);
        buf.writeBoolean(this.universeEnabled);
        buf.writeBoolean(this.addressEnabled);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player player = context.getPlayer();
            ItemStack itemStack = null;
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.CONFIGURATION_CARD.get()) {
                itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            } else if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == Items.CONFIGURATION_CARD.get()) {
                itemStack = player.m_21120_(InteractionHand.OFF_HAND);
            }
            if (itemStack != null) {
                CompoundTag dataTag = itemStack.m_41784_();
                dataTag.m_128362_("network", this.network);
                dataTag.m_128405_("dmxUniverse", this.dmxUniverse);
                dataTag.m_128405_("dmxAddress", this.dmxAddress);
                dataTag.m_128379_("autoIncrement", this.autoIncrement);
                dataTag.m_128379_("universeEnabled", this.universeEnabled);
                dataTag.m_128379_("addressEnabled", this.addressEnabled);
                itemStack.m_41739_(dataTag);
            }
        });
    }
}

