/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net.artnet;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.dmx.DMXDevice;
import dev.imabad.theatrical.net.TheatricalNet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;

public class NotifyConsumerChange
extends BaseS2CMessage {
    private int universe;
    private ChangeType changeType;
    private DMXDevice dmxDevice;

    public NotifyConsumerChange(int universe, ChangeType changeType, DMXDevice dmxDevice) {
        this.universe = universe;
        this.changeType = changeType;
        this.dmxDevice = dmxDevice;
    }

    public NotifyConsumerChange(FriendlyByteBuf buf) {
        this.universe = buf.readInt();
        this.changeType = ChangeType.valueOf(buf.m_130277_());
        if (buf.readBoolean()) {
            this.dmxDevice = new DMXDevice(new RDMDeviceId(buf.m_130101_(6)), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.m_130277_(), buf.m_130281_());
        }
    }

    public MessageType getType() {
        return TheatricalNet.NOTIFY_CONSUMER_CHANGE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.universe);
        buf.m_130070_(this.changeType.name());
        buf.writeBoolean(this.dmxDevice != null);
        if (this.dmxDevice != null) {
            buf.m_130087_(this.dmxDevice.getDeviceId().toBytes());
            buf.writeInt(this.dmxDevice.getDmxStartAddress());
            buf.writeInt(this.dmxDevice.getDmxChannelCount());
            buf.writeInt(this.dmxDevice.getDeviceTypeId());
            buf.writeInt(this.dmxDevice.getActivePersonality());
            buf.m_130070_(this.dmxDevice.getModelName());
            buf.m_130085_(this.dmxDevice.getFixtureID());
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnv() == Dist.CLIENT) {
            TheatricalClient.handleConsumerChange(this);
        }
    }

    public int getUniverse() {
        return this.universe;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public DMXDevice getDmxDevice() {
        return this.dmxDevice;
    }

    public static enum ChangeType {
        ADD,
        UPDATE,
        REMOVE;

    }
}

