/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net.artnet;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.blockentities.interfaces.RedstoneInterfaceBlockEntity;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.net.TheatricalNet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RDMUpdateConsumer
extends BaseC2SMessage {
    private final UUID networkId;
    private final int universe;
    private final int newAddress;
    private final RDMDeviceId dmxDevice;

    public RDMUpdateConsumer(UUID networkId, int universe, RDMDeviceId dmxDevice, int newAddress) {
        this.networkId = networkId;
        this.universe = universe;
        this.dmxDevice = dmxDevice;
        this.newAddress = newAddress;
    }

    public RDMUpdateConsumer(FriendlyByteBuf buf) {
        this.networkId = buf.m_130259_();
        this.universe = buf.readInt();
        this.dmxDevice = new RDMDeviceId(buf.m_130101_(6));
        this.newAddress = buf.readInt();
    }

    public MessageType getType() {
        return TheatricalNet.RDM_UPDATE_FIXTURE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.networkId);
        buf.writeInt(this.universe);
        buf.m_130087_(this.dmxDevice.toBytes());
        buf.writeInt(this.newAddress);
    }

    public void handle(NetworkManager.PacketContext context) {
        Level level = context.getPlayer().m_9236_();
        if (level.m_7654_() != null) {
            DMXNetwork network = DMXNetworkData.getInstance((Level)level.m_7654_().m_129783_()).getNetwork(this.networkId);
            if (network == null || !network.canSendDMX(context.getPlayer().m_20148_())) {
                Theatrical.LOGGER.info("{} tried to send an RDM update for a network that doesn't exist or isn't part of", (Object)context.getPlayer().m_7755_().getString());
                return;
            }
            BlockPos consumerPos = network.getConsumerPos(this.universe, this.dmxDevice);
            if (consumerPos != null) {
                BlockEntity be = context.getPlayer().m_9236_().m_7702_(consumerPos);
                if (be instanceof BaseDMXConsumerLightBlockEntity) {
                    BaseDMXConsumerLightBlockEntity dmxConsumerLightBlock = (BaseDMXConsumerLightBlockEntity)be;
                    dmxConsumerLightBlock.setChannelStartPoint(this.newAddress);
                } else if (be instanceof RedstoneInterfaceBlockEntity) {
                    RedstoneInterfaceBlockEntity redstoneInterfaceBlockEntity = (RedstoneInterfaceBlockEntity)be;
                    redstoneInterfaceBlockEntity.setChannelStartPoint(this.newAddress);
                }
            }
        }
    }

    public int getUniverse() {
        return this.universe;
    }

    public int getNewAddress() {
        return this.newAddress;
    }
}

