/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net.artnet;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.dmx.DMXDevice;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.net.TheatricalNet;
import dev.imabad.theatrical.net.artnet.ListConsumers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class RequestConsumers
extends BaseC2SMessage {
    private final UUID networkId;
    private final int universe;

    public RequestConsumers(UUID networkId, int universe) {
        this.networkId = networkId;
        this.universe = universe;
    }

    public RequestConsumers(FriendlyByteBuf byteBuf) {
        this.networkId = byteBuf.m_130259_();
        this.universe = byteBuf.readInt();
    }

    public MessageType getType() {
        return TheatricalNet.REQUEST_CONSUMERS;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.networkId);
        buf.writeInt(this.universe);
    }

    public void handle(NetworkManager.PacketContext context) {
        Level level = context.getPlayer().m_9236_();
        if (level.m_7654_() != null) {
            DMXNetwork network = DMXNetworkData.getInstance((Level)level.m_7654_().m_129783_()).getNetwork(this.networkId);
            if (network != null && network.isMember(context.getPlayer().m_20148_())) {
                ArrayList<DMXDevice> devices = new ArrayList<DMXDevice>();
                Collection<DMXConsumer> consumers = network.getConsumers(this.universe);
                if (consumers == null) {
                    return;
                }
                consumers.forEach(consumer -> devices.add(new DMXDevice(consumer.getDeviceId(), consumer.getChannelStart(), consumer.getChannelCount(), consumer.getDeviceTypeId(), consumer.getActivePersonality(), consumer.getModelName(), consumer.getFixtureId())));
                new ListConsumers(this.universe, devices).sendTo((ServerPlayer)context.getPlayer());
            } else {
                Theatrical.LOGGER.info("{} tried to request data about a network that does not exist", (Object)context.getPlayer().m_7755_().getString());
            }
        }
    }
}

