/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.imabad.theatrical.TheatricalRegistry;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.commands.DMXNetworkModeArgument;
import dev.imabad.theatrical.commands.MemberRoleArgument;
import dev.imabad.theatrical.commands.NetworkCommand;
import dev.imabad.theatrical.config.ConfigHandler;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.dmx.DMXDevice;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.fixtures.Fixtures;
import dev.imabad.theatrical.items.Items;
import dev.imabad.theatrical.mixin.ArgumentTypeInfosAccessor;
import dev.imabad.theatrical.net.TheatricalNet;
import dev.imabad.theatrical.net.artnet.ListConsumers;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Theatrical {
    public static final String MOD_ID = "theatrical";
    public static final DeferredRegister<CreativeModeTab> TABS = TheatricalRegistry.get(Registries.CREATIVE_MODE_TAB);
    public static final RegistrySupplier<CreativeModeTab> TAB = TABS.register("theatrical", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.theatrical"), () -> new ItemStack((ItemLike)Items.ART_NET_INTERFACE.get())));
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"theatrical");

    public static void init() {
        ConfigHandler configHandler = ConfigHandler.initialize(Platform.getConfigFolder());
        TheatricalConfig.INSTANCE.register(configHandler);
        TABS.register();
        Fixtures.init();
        TheatricalNet.init();
        Blocks.BLOCKS.register();
        BlockEntities.BLOCK_ENTITIES.register();
        DeferredRegister argTypes = TheatricalRegistry.get(Registries.COMMAND_ARGUMENT_TYPE);
        Theatrical.registerArgument(argTypes, SingletonArgumentInfo.contextFree(DMXNetworkModeArgument::networkMode), "network_mode", DMXNetworkModeArgument.class);
        Theatrical.registerArgument(argTypes, SingletonArgumentInfo.contextFree(MemberRoleArgument::memberRole), "member_role", MemberRoleArgument.class);
        argTypes.register();
        Items.ITEMS.register();
        PlayerEvent.PLAYER_JOIN.register(event -> {
            DMXNetworkData instance = DMXNetworkData.getInstance((Level)event.server.overworld());
            for (DMXNetwork network : instance.getNetworksForPlayer(event.connection.player.getUUID())) {
                for (Integer universe : network.getUniverses()) {
                    ArrayList<DMXDevice> devices = new ArrayList<DMXDevice>();
                    network.getConsumers(universe).forEach(consumer -> devices.add(new DMXDevice(consumer.getDeviceId(), consumer.getChannelStart(), consumer.getChannelCount(), consumer.getDeviceTypeId(), consumer.getActivePersonality(), consumer.getModelName(), consumer.getFixtureId())));
                    new ListConsumers(universe, devices).sendTo(event.connection.player);
                }
            }
        });
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(world -> {
            if (world.dimension().equals(Level.OVERWORLD)) {
                DMXNetworkData.unloadLevel();
            }
        });
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> NetworkCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher));
    }

    private static void registerArgument(DeferredRegister<ArgumentTypeInfo<?, ?>> argTypes, ArgumentTypeInfo<?, ?> serializer, String id, Class<?> clazz) {
        argTypes.register(new ResourceLocation(MOD_ID, id), () -> serializer);
        ArgumentTypeInfosAccessor.classMap().put(clazz, serializer);
    }
}

