/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.interfaces;

import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ArtNetInterfaceBlockEntity
extends ClientSyncBlockEntity {
    private int subnet;
    private int universe;
    private int tickTimer = 0;
    private String ip = "127.0.0.1";
    private UUID networkId = UUIDUtil.NULL;

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        ArtNetInterfaceBlockEntity tile = (ArtNetInterfaceBlockEntity)be;
    }

    public ArtNetInterfaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.ART_NET_INTERFACE.get(), blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        compoundTag.putString("ip", this.ip);
        compoundTag.putInt("subnet", this.subnet);
        compoundTag.putInt("universe", this.universe);
        if (this.networkId != null) {
            compoundTag.putUUID("networkId", this.networkId);
        }
    }

    @Override
    public void read(CompoundTag compoundTag) {
        this.ip = compoundTag.getString("ip");
        this.subnet = compoundTag.getInt("subnet");
        this.universe = compoundTag.getInt("universe");
        if (compoundTag.contains("networkId")) {
            this.networkId = compoundTag.getUUID("networkId");
        }
    }

    public void update(byte[] data) {
        DMXNetwork dmxData;
        if (this.level != null && this.level.getServer() != null && (dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId)) != null) {
            dmxData.getConsumersInRange(this.universe, this.getBlockPos(), TheatricalConfig.INSTANCE.COMMON.wirelessDMXRadius).forEach(dmxConsumer -> dmxConsumer.consume(data));
        }
    }

    public boolean hasReceivedPacket() {
        return false;
    }

    public long getLastReceivedPacket() {
        return 0L;
    }

    public int getUniverse() {
        return this.universe;
    }

    public String getIp() {
        return this.ip;
    }

    public void updateConfig(String ipAddress, int dmxUniverse) {
        this.ip = ipAddress;
        this.universe = dmxUniverse;
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }
}

