/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import dev.imabad.theatrical.fixtures.Fixtures;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LEDPanelBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    public LEDPanelBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.LED_PANEL.get(), blockPos, blockState);
        this.setChannelCount(4);
    }

    @Override
    public Fixture getFixture() {
        return (Fixture)Fixtures.LED_PANEL.get();
    }

    @Override
    public void consume(byte[] dmxValues) {
        int newBlue;
        int newGreen;
        int newRed;
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 4) {
            return;
        }
        if (this.storePrev()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        boolean hasUpdated = false;
        int newIntensity = this.convertByteToInt(ourValues[0]);
        if (this.intensity != newIntensity) {
            this.intensity = newIntensity;
            hasUpdated = true;
        }
        if (this.red != (newRed = this.convertByteToInt(ourValues[1]))) {
            this.red = newRed;
            hasUpdated = true;
        }
        if (this.green != (newGreen = this.convertByteToInt(ourValues[2]))) {
            this.green = newGreen;
            hasUpdated = true;
        }
        if (this.blue != (newBlue = this.convertByteToInt(ourValues[3]))) {
            this.blue = newBlue;
            hasUpdated = true;
        }
        if (hasUpdated) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public int getDeviceTypeId() {
        return 3;
    }

    @Override
    public String getModelName() {
        return "LED Panel";
    }

    @Override
    public ResourceLocation getFixtureId() {
        return Fixtures.LED_PANEL.getId();
    }

    @Override
    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    @Override
    public float getMaxLightDistance() {
        return 1.0f;
    }

    @Override
    public String getTranslationKey() {
        return "block.theatrical.led_panel";
    }
}

