/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.interfaces;

import dev.imabad.theatrical.blockentities.interfaces.ArtNetInterfaceBlockEntity;
import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.client.gui.screen.ArtNetInterfaceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArtNetInterfaceBlock
extends Block
implements EntityBlock {
    public ArtNetInterfaceBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 3.0f).noOcclusion().isValidSpawn(Blocks::neverAllowSpawn).mapColor(MapColor.METAL).sound(SoundType.METAL));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ArtNetInterfaceBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? ArtNetInterfaceBlockEntity::tick : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            ArtNetInterfaceBlockEntity be = (ArtNetInterfaceBlockEntity)level.getBlockEntity(pos);
            Minecraft.getInstance().setScreen((Screen)new ArtNetInterfaceScreen(be));
        }
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof ArtNetInterfaceBlockEntity) {
            ArtNetInterfaceBlockEntity interfaceBlock = (ArtNetInterfaceBlockEntity)be;
            if (placer != null) {
                // empty if block
            }
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }
}

