/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.light;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.TheatricalScreen;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.light.BaseLightBlockEntity;
import dev.imabad.theatrical.blockentities.light.MovingWashBlockEntity;
import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.blocks.light.BaseLightBlock;
import dev.imabad.theatrical.net.OpenScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MovingWashBlock
extends BaseLightBlock {
    public MovingWashBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 3.0f).noOcclusion().isValidSpawn(Blocks::neverAllowSpawn).mapColor(MapColor.METAL).sound(SoundType.METAL).pushReaction(PushReaction.DESTROY));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MovingWashBlockEntity(blockPos, blockState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)super.getStateForPlacement(blockPlaceContext).setValue((Property)HANGING, (Comparable)Boolean.valueOf(blockPlaceContext.getClickedFace() == Direction.DOWN || this.isHanging((LevelReader)blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos())));
    }

    @Override
    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (((Boolean)blockState.getValue((Property)HANGING)).booleanValue()) {
            return this.isHanging(levelReader, blockPos);
        }
        return !levelReader.getBlockState(blockPos.below()).isAir();
    }

    @Override
    public Direction getLightFacing(Direction hangDirection, Player placingPlayer) {
        if (hangDirection == Direction.UP) {
            return placingPlayer.getDirection();
        }
        Direction playerFacing = placingPlayer.getDirection();
        return playerFacing.getOpposite();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == BlockEntities.MOVING_WASH.get() ? BaseLightBlockEntity::tick : null;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() == null) {
            return Shapes.empty();
        }
        return super.getVisualShape(state, level, pos, context);
    }

    @Override
    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (super.use(state, level, pos, player, hand, hit) == InteractionResult.PASS) {
            if (level.isClientSide) {
                if (player.isCrouching()) {
                    if (TheatricalClient.DEBUG_BLOCKS.contains(pos)) {
                        TheatricalClient.DEBUG_BLOCKS.remove(pos);
                    } else {
                        TheatricalClient.DEBUG_BLOCKS.add(pos);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                new OpenScreen(pos, TheatricalScreen.GENERIC_DMX).sendTo((ServerPlayer)player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            TheatricalClient.DEBUG_BLOCKS.remove(pos);
        }
        super.destroy(level, pos, state);
    }
}

