/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.rigging;

import dev.imabad.theatrical.api.FixtureProvider;
import dev.imabad.theatrical.api.HangType;
import dev.imabad.theatrical.api.Support;
import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.blocks.light.BaseLightBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends DirectionalBlock
implements Support {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    private final VoxelShape Z_BOX = Shapes.create((AABB)new AABB(0.35, 0.4, 0.0, 0.65, 0.6, 1.0));
    private final VoxelShape Z_BOX_DOWN = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0));
    private final VoxelShape Z_BOX_UP = Shapes.create((AABB)new AABB(0.0, 0.4, 0.0, 1.0, 1.0, 1.0));
    private final VoxelShape X_BOX = Shapes.create((AABB)new AABB(0.0, 0.4, 0.4, 1.0, 0.6, 0.6));
    private final VoxelShape X_BOX_DOWN = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0));
    private final VoxelShape X_BOX_UP = Shapes.create((AABB)new AABB(0.0, 0.4, 0.0, 1.0, 1.0, 1.0));
    private final VoxelShape Y_BOX = Shapes.create((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 1.0, 0.6));
    private final VoxelShape Y_BOX_SOUTH = Shapes.create((AABB)new AABB(0.0, 0.0, 0.4, 1.0, 1.0, 1.0));
    private final VoxelShape Y_BOX_NORTH = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.6));
    private final VoxelShape Y_BOX_EAST = Shapes.create((AABB)new AABB(0.4, 0.0, 0.0, 1.0, 1.0, 1.0));
    private final VoxelShape Y_BOX_WEST = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 0.6, 1.0, 1.0));

    public PipeBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(3.0f, 3.0f).noOcclusion().isValidSpawn(Blocks::neverAllowSpawn).mapColor(MapColor.METAL).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public float[] getHookTransforms(LevelReader levelReader, BlockPos pos, Direction facing) {
        if (levelReader.getBlockState(pos).getValue((Property)BaseLightBlock.HANG_DIRECTION) == Direction.UP) {
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        BlockEntity blockEntity = levelReader.getBlockEntity(pos);
        if (blockEntity instanceof FixtureProvider) {
            FixtureProvider fixtureProvider = (FixtureProvider)blockEntity;
            if (fixtureProvider.getFixture().getHangType() == HangType.BRACE_BAR) {
                return new float[]{0.0f, -0.35f, 0.0f};
            }
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Y) {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            for (Direction dir : Direction.values()) {
                BlockState blockState;
                if (dir.getAxis() == Direction.Axis.Y || !((blockState = level.getBlockState(pos.relative(dir))).getBlock() instanceof HangableBlock) || blockState.getValue((Property)HangableBlock.HANG_DIRECTION) != dir.getOpposite()) continue;
                VoxelShape extensionShape = null;
                switch (dir) {
                    case SOUTH: {
                        extensionShape = this.Y_BOX_SOUTH;
                        break;
                    }
                    case NORTH: {
                        extensionShape = this.Y_BOX_NORTH;
                        break;
                    }
                    case EAST: {
                        extensionShape = this.Y_BOX_EAST;
                        break;
                    }
                    case WEST: {
                        extensionShape = this.Y_BOX_WEST;
                    }
                }
                shapes.add(extensionShape);
            }
            return Shapes.or((VoxelShape)this.Y_BOX, (VoxelShape[])shapes.toArray(new VoxelShape[0]));
        }
        if (level.getBlockState(pos.relative(Direction.DOWN)).getBlock() instanceof HangableBlock) {
            VoxelShape ogShape = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? this.Z_BOX : this.X_BOX;
            VoxelShape extensionShape = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? this.Z_BOX_DOWN : this.X_BOX_DOWN;
            return Shapes.or((VoxelShape)ogShape, (VoxelShape)extensionShape);
        }
        if (level.getBlockState(pos.relative(Direction.UP)).getBlock() instanceof HangableBlock) {
            VoxelShape ogShape = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? this.Z_BOX : this.X_BOX;
            VoxelShape extensionShape = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? this.Z_BOX_UP : this.X_BOX_UP;
            return Shapes.or((VoxelShape)ogShape, (VoxelShape)extensionShape);
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? this.Z_BOX : (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Y ? this.Y_BOX : this.X_BOX);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem blockItem;
        Block block;
        Item item;
        if (!player.getItemInHand(hand).isEmpty() && (item = player.getItemInHand(hand).getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof HangableBlock) {
            HangableBlock hangableBlock = (HangableBlock)block;
            BlockPos offset = ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Y ? pos.relative(player.getDirection().getOpposite()) : (hit.getDirection() == Direction.UP ? pos.relative(Direction.UP) : pos.relative(Direction.DOWN));
            if (!level.getBlockState(offset).isAir()) {
                return InteractionResult.FAIL;
            }
            Direction hangDirection = Direction.UP;
            if (((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Y) {
                hangDirection = player.getDirection();
            } else if (hit.getDirection() == Direction.UP) {
                hangDirection = Direction.DOWN;
            }
            Direction facingDirection = hangableBlock.getLightFacing(hangDirection, player);
            level.setBlock(offset, (BlockState)((BlockState)((BlockState)hangableBlock.defaultBlockState().setValue((Property)HangableBlock.FACING, (Comparable)facingDirection)).setValue((Property)HangableBlock.HANGING, (Comparable)Boolean.valueOf(true))).setValue((Property)HangableBlock.HANG_DIRECTION, (Comparable)hangDirection), 2);
            if (!player.isCreative()) {
                if (player.getItemInHand(hand).getCount() > 1) {
                    player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
                } else {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.AIR));
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.use(state, level, pos, player, hand, hit);
    }
}

