/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.imabad.theatrical.blockentities.control.BasicLightingDeskBlockEntity;
import dev.imabad.theatrical.client.TheatricalRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class BasicLightingConsoleRenderer
implements BlockEntityRenderer<BasicLightingDeskBlockEntity> {
    public BasicLightingConsoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public float convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public void render(BasicLightingDeskBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        BlockState blockState = blockEntity.getBlockState();
        Direction blockDirection = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        poseStack.translate(0.5, 0.5, 0.5);
        if (blockDirection.getAxis() == Direction.Axis.X) {
            blockDirection = blockDirection.getOpposite();
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(blockDirection.toYRot()));
        poseStack.translate(-0.5, -0.5, -0.5);
        double startX = 1.5;
        byte[] faders = blockEntity.getFaders();
        VertexConsumer linesVertexBuilder = buffer.getBuffer(RenderType.lines());
        for (int i = 0; i < faders.length; ++i) {
            double baseY = 5.4;
            if (i >= 6) {
                baseY += (double)(i / 6 * 7);
            }
            int faderNumber = i - i / 6 * 6;
            this.renderLine(poseStack, startX + (double)faderNumber * 1.2, baseY, linesVertexBuilder);
        }
        this.renderLine(poseStack, 14.5, 5.4, linesVertexBuilder);
        VertexConsumer iVertexBuilder = buffer.getBuffer(TheatricalRenderTypes.FADER);
        for (int i = 0; i < faders.length; ++i) {
            double baseY = 5.4;
            if (i >= 6) {
                baseY += (double)(i / 6 * 7);
            }
            int faderNumber = i - i / 6 * 6;
            this.renderFader(poseStack, startX + (double)faderNumber * 1.2, baseY, -(this.convertByteToInt(faders[i]) / 255.0f * 3.0f), iVertexBuilder);
        }
        this.renderFader(poseStack, 14.5, 5.4, -(this.convertByteToInt(blockEntity.getGrandMaster()) / 255.0f * 3.0f), iVertexBuilder);
        poseStack.popPose();
    }

    public void renderStep(PoseStack stack, BasicLightingDeskBlockEntity tileEntityBasicLightingControl, MultiBufferSource buffer, int combinedLightIn) {
        stack.pushPose();
        Font font = Minecraft.getInstance().font;
        stack.translate(0.66875, 0.1875, 0.58125);
        stack.scale(0.005f, -0.005f, 0.005f);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        font.drawInBatch("STEP", 0.0f, 0.0f, -1, false, stack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        stack.popPose();
    }

    public void renderCurrentMode(PoseStack stack, BasicLightingDeskBlockEntity tileEntityBasicLightingControl, MultiBufferSource buffer, int combinedLightIn) {
        stack.pushPose();
        Font font = Minecraft.getInstance().font;
        stack.translate(0.65, 0.1875, 0.51875);
        stack.scale(0.003f, -0.003f, 0.003f);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        font.drawInBatch(tileEntityBasicLightingControl.isRunMode() ? "Run mode" : "Program mode", 0.0f, 0.0f, 0, false, stack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        stack.popPose();
    }

    public void renderLine(PoseStack stack, double x, double y, VertexConsumer vertexBuilder) {
        stack.pushPose();
        Matrix4f m = stack.last().pose();
        stack.translate(x / 16.0, 0.1875, y / 16.0);
        vertexBuilder.vertex(m, 0.0f, 0.0f, 0.0f).color(0, 0, 0, 255).normal(0.0f, 0.0f, 0.0f).endVertex();
        vertexBuilder.vertex(m, 0.0f, 0.0f, -0.1875f).color(0, 0, 0, 255).normal(0.0f, 0.0f, 0.0f).endVertex();
        stack.popPose();
    }

    public void renderFader(PoseStack stack, double x, double baseY, double faderY, VertexConsumer builder) {
        stack.pushPose();
        Matrix4f m = stack.last().pose();
        float height = 0.025f;
        float width = 0.0375f;
        stack.translate(x / 16.0 - (double)(width / 2.0f), 0.1875, (baseY + faderY) / 16.0);
        builder.vertex(m, width, height, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, height, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, 0.0f, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, 0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, 0.0f, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, 0.0f, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, height, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, height, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, 0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, 0.0f, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, height, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, height, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, height, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, height, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, 0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, 0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, 0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, 0.0f, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, 0.0f, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, 0.0f, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, height, 0.0f).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, 0.0f, height, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, height, width).color(0, 0, 0, 255).endVertex();
        builder.vertex(m, width, height, 0.0f).color(0, 0, 0, 255).endVertex();
        stack.popPose();
    }
}

