/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.imabad.theatrical.TheatricalExpectPlatform;
import dev.imabad.theatrical.blockentities.light.FresnelBlockEntity;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.client.LazyRenderers;
import dev.imabad.theatrical.client.TheatricalRenderTypes;
import dev.imabad.theatrical.client.blockentities.FixtureRenderer;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class FresnelRenderer
extends FixtureRenderer<FresnelBlockEntity> {
    private BakedModel cachedPanModel;
    private BakedModel cachedTiltModel;
    private BakedModel cachedStaticModel;

    public FresnelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void renderModel(FresnelBlockEntity blockEntity, PoseStack poseStack, VertexConsumer vertexConsumer, Direction facing, float partialTicks, boolean isFlipped, BlockState blockState, boolean isHanging, int packedLight, int packedOverlay) {
        if (this.cachedStaticModel == null) {
            this.cachedStaticModel = TheatricalExpectPlatform.getBakedModel(blockEntity.getFixture().getStaticModel());
        }
        if (this.cachedPanModel == null) {
            this.cachedPanModel = TheatricalExpectPlatform.getBakedModel(blockEntity.getFixture().getPanModel());
        }
        if (this.cachedTiltModel == null) {
            this.cachedTiltModel = TheatricalExpectPlatform.getBakedModel(blockEntity.getFixture().getTiltModel());
        }
        poseStack.translate(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            Direction hangDirection = (Direction)blockState.getValue((Property)HangableBlock.HANG_DIRECTION);
            poseStack.translate(0.0, 0.5, 0.0);
            if (hangDirection.getAxis() != Direction.Axis.Y) {
                if (hangDirection.getAxis() == Direction.Axis.Z) {
                    if (hangDirection == Direction.SOUTH) {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    } else {
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                    }
                } else if (hangDirection == Direction.EAST) {
                    poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                } else {
                    poseStack.mulPose(Axis.ZN.rotationDegrees(-90.0f));
                }
            }
            poseStack.translate(0.0, -0.5, 0.0);
        }
        if (facing.getAxis() == Direction.Axis.X) {
            poseStack.mulPose(Axis.YP.rotationDegrees(facing.toYRot()));
        } else {
            poseStack.mulPose(Axis.YP.rotationDegrees(facing.getOpposite().toYRot()));
        }
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional<BlockState> optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, optionalSupport.get());
                poseStack.translate(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.translate(0.0, 0.19, 0.0);
            }
        }
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedStaticModel, packedLight, packedOverlay);
        float[] pans = blockEntity.getFixture().getPanRotationPosition();
        poseStack.translate(pans[0], pans[1], pans[2]);
        int prevPan = blockEntity.getPrevPan();
        int pan = blockEntity.getPan();
        poseStack.mulPose(Axis.YN.rotationDegrees((float)prevPan + (float)(pan - prevPan) * partialTicks));
        poseStack.translate(-pans[0], -pans[1], -pans[2]);
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedPanModel, packedLight, packedOverlay);
        float[] tilts = blockEntity.getFixture().getTiltRotationPosition();
        poseStack.translate(tilts[0], tilts[1], tilts[2]);
        int prevTilt = blockEntity.getPrevTilt();
        int tilt = blockEntity.getTilt();
        poseStack.mulPose(Axis.XP.rotationDegrees((float)prevTilt + (float)(tilt - prevTilt) * partialTicks));
        poseStack.translate(-tilts[0], -tilts[1], -tilts[2]);
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedTiltModel, packedLight, packedOverlay);
    }

    @Override
    public void beforeRenderBeam(final FresnelBlockEntity blockEntity, PoseStack poseStack, VertexConsumer vertexConsumer, final MultiBufferSource multiBufferSource, final Direction facing, final float partialTicks, final boolean isFlipped, final BlockState blockstate, final boolean isHanging, int packedLight, int packedOverlay) {
        if (blockEntity.getIntensity() > 0.0f) {
            LazyRenderers.addLazyRender(new LazyRenderers.LazyRenderer(){

                @Override
                public void render(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, Camera camera, float partialTick) {
                    poseStack.pushPose();
                    Vec3 offset = Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos()).subtract(camera.getPosition());
                    poseStack.translate(offset.x, offset.y, offset.z);
                    FresnelRenderer.this.preparePoseStack(blockEntity, poseStack, facing, partialTick, isFlipped, blockstate, isHanging);
                    VertexConsumer beamConsumer = multiBufferSource.getBuffer(TheatricalRenderTypes.BEAM);
                    float intensity = (float)blockEntity.getPrevIntensity() + (blockEntity.getIntensity() - (float)blockEntity.getPrevIntensity()) * partialTicks;
                    int color = blockEntity.getColour();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    int a = (int)(intensity * 1.0f / 255.0f * 255.0f);
                    poseStack.translate(0.0f, -0.25f, 0.05f);
                    Matrix4f m = poseStack.last().pose();
                    Matrix3f normal = poseStack.last().normal();
                    FresnelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 0.34375f, 0.65625f, 0.0f);
                    FresnelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 0.65625f, 0.65625f, 0.0f);
                    FresnelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 0.65625f, 0.34375f, 0.0f);
                    FresnelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 0.34375f, 0.34375f, 0.0f);
                    poseStack.popPose();
                }

                @Override
                public Vec3 getPos(float partialTick) {
                    return blockEntity.getBlockPos().getCenter();
                }
            });
        }
    }

    @Override
    public void preparePoseStack(FresnelBlockEntity blockEntity, PoseStack poseStack, Direction facing, float partialTicks, boolean isFlipped, BlockState blockState, boolean isHanging) {
        poseStack.translate(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            Direction hangDirection = (Direction)blockState.getValue((Property)HangableBlock.HANG_DIRECTION);
            poseStack.translate(0.0, 0.5, 0.0);
            if (hangDirection.getAxis() != Direction.Axis.Y) {
                if (hangDirection.getAxis() == Direction.Axis.Z) {
                    if (hangDirection == Direction.SOUTH) {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    } else {
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                    }
                } else if (hangDirection == Direction.EAST) {
                    poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                } else {
                    poseStack.mulPose(Axis.ZN.rotationDegrees(-90.0f));
                }
            }
            poseStack.translate(0.0, -0.5, 0.0);
        }
        if (facing.getAxis() == Direction.Axis.X) {
            poseStack.mulPose(Axis.YP.rotationDegrees(facing.toYRot()));
        } else {
            poseStack.mulPose(Axis.YP.rotationDegrees(facing.getOpposite().toYRot()));
        }
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional<BlockState> optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, optionalSupport.get());
                poseStack.translate(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.translate(0.0, 0.19, 0.0);
            }
        }
        float[] pans = blockEntity.getFixture().getPanRotationPosition();
        poseStack.translate(pans[0], pans[1], pans[2]);
        int prevPan = blockEntity.getPrevPan();
        int pan = blockEntity.getPan();
        poseStack.mulPose(Axis.YN.rotationDegrees((float)prevPan + (float)(pan - prevPan) * partialTicks));
        poseStack.translate(-pans[0], -pans[1], -pans[2]);
        float[] tilts = blockEntity.getFixture().getTiltRotationPosition();
        poseStack.translate(tilts[0], tilts[1], tilts[2]);
        int prevTilt = blockEntity.getPrevTilt();
        int tilt = blockEntity.getTilt();
        poseStack.mulPose(Axis.XP.rotationDegrees((float)prevTilt + (float)(tilt - prevTilt) * partialTicks));
        poseStack.translate(-tilts[0], -tilts[1], -tilts[2]);
    }
}

