/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.blockentities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.imabad.theatrical.TheatricalExpectPlatform;
import dev.imabad.theatrical.blockentities.light.LEDPanelBlockEntity;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.client.LazyRenderers;
import dev.imabad.theatrical.client.TheatricalRenderTypes;
import dev.imabad.theatrical.client.blockentities.FixtureRenderer;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class LEDPanelRenderer
extends FixtureRenderer<LEDPanelBlockEntity> {
    private BakedModel cachedStaticModel;

    public LEDPanelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void renderModel(LEDPanelBlockEntity blockEntity, PoseStack poseStack, VertexConsumer vertexConsumer, Direction facing, float partialTicks, boolean isFlipped, BlockState blockState, boolean isHanging, int packedLight, int packedOverlay) {
        if (this.cachedStaticModel == null) {
            this.cachedStaticModel = TheatricalExpectPlatform.getBakedModel(blockEntity.getFixture().getStaticModel());
        }
        poseStack.translate(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            Direction hangDirection = (Direction)blockState.getValue((Property)HangableBlock.HANG_DIRECTION);
            poseStack.translate(0.0, 0.5, 0.0);
            if (hangDirection.getAxis() != Direction.Axis.Y) {
                if (hangDirection.getAxis() == Direction.Axis.Z) {
                    if (hangDirection == Direction.SOUTH) {
                        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
                    } else {
                        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
                    }
                }
            } else if (hangDirection == Direction.UP) {
                switch (facing) {
                    case NORTH: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    }
                }
            } else if (hangDirection == Direction.DOWN) {
                switch (facing) {
                    case NORTH: {
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    }
                }
            }
            poseStack.translate(0.0, -0.5, 0.0);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(facing.toYRot()));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional<BlockState> optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, optionalSupport.get());
                poseStack.translate(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.translate(0.0, 0.19, 0.0);
            }
        }
        this.minecraftRenderModel(poseStack, vertexConsumer, blockState, this.cachedStaticModel, packedLight, packedOverlay);
    }

    @Override
    public void beforeRenderBeam(final LEDPanelBlockEntity blockEntity, PoseStack poseStack, VertexConsumer vertexConsumer, final MultiBufferSource multiBufferSource, final Direction facing, final float partialTicks, final boolean isFlipped, final BlockState blockstate, final boolean isHanging, int packedLight, int packedOverlay) {
        if (blockEntity.getIntensity() > 0.0f) {
            LazyRenderers.addLazyRender(new LazyRenderers.LazyRenderer(){

                @Override
                public void render(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, Camera camera, float partialTick) {
                    poseStack.pushPose();
                    Vec3 offset = Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos()).subtract(camera.getPosition());
                    poseStack.translate(offset.x, offset.y, offset.z);
                    LEDPanelRenderer.this.preparePoseStack(blockEntity, poseStack, facing, partialTick, isFlipped, blockstate, isHanging);
                    VertexConsumer beamConsumer = multiBufferSource.getBuffer(TheatricalRenderTypes.BEAM);
                    float intensity = (float)blockEntity.getPrevIntensity() + (blockEntity.getIntensity() - (float)blockEntity.getPrevIntensity()) * partialTicks;
                    int color = blockEntity.getColour();
                    int r = color >> 16 & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color & 0xFF;
                    int a = (int)(intensity * 1.0f / 255.0f * 255.0f);
                    poseStack.translate(0.0f, 0.0f, -0.01f);
                    Matrix4f m = poseStack.last().pose();
                    Matrix3f normal = poseStack.last().normal();
                    LEDPanelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 0.0f, 1.0f, 0.0f);
                    LEDPanelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 1.0f, 1.0f, 0.0f);
                    LEDPanelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 1.0f, 0.0f, 0.0f);
                    LEDPanelRenderer.this.addVertex(beamConsumer, m, normal, r, g, b, a, 0.0f, 0.0f, 0.0f);
                    poseStack.popPose();
                }

                @Override
                public Vec3 getPos(float partialTick) {
                    return blockEntity.getBlockPos().getCenter();
                }
            });
        }
    }

    @Override
    public void preparePoseStack(LEDPanelBlockEntity blockEntity, PoseStack poseStack, Direction facing, float partialTicks, boolean isFlipped, BlockState blockState, boolean isHanging) {
        poseStack.translate(0.5f, 0.0f, 0.5f);
        if (isHanging) {
            Direction hangDirection = (Direction)blockState.getValue((Property)HangableBlock.HANG_DIRECTION);
            poseStack.translate(0.0, 0.5, 0.0);
            if (hangDirection.getAxis() != Direction.Axis.Y) {
                if (hangDirection.getAxis() == Direction.Axis.Z) {
                    if (hangDirection == Direction.SOUTH) {
                        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
                    } else {
                        poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
                    }
                }
            } else if (hangDirection == Direction.UP) {
                switch (facing) {
                    case NORTH: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    }
                }
            } else if (hangDirection == Direction.DOWN) {
                switch (facing) {
                    case NORTH: {
                        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    }
                }
            }
            poseStack.translate(0.0, -0.5, 0.0);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(facing.toYRot()));
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        if (isHanging) {
            Optional<BlockState> optionalSupport = blockEntity.getSupportingStructure();
            if (optionalSupport.isPresent()) {
                float[] transforms = blockEntity.getFixture().getTransforms(blockState, optionalSupport.get());
                poseStack.translate(transforms[0], transforms[1], transforms[2]);
            } else {
                poseStack.translate(0.0, 0.19, 0.0);
            }
        }
    }
}

