/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.dmx;

import dev.imabad.theatrical.client.dmx.ArtNetToNetworkClientData;
import dev.imabad.theatrical.client.dmx.SavedClientNetworkManager;
import dev.imabad.theatrical.client.dmx.TheatricalArtNetClient;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.util.UUIDUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.level.Level;

public class ArtNetManager {
    private static final UUID NULL = UUIDUtil.NULL;
    private TheatricalArtNetClient artNetClient;
    private final Map<UUID, String> knownNetworks = new HashMap<UUID, String>();
    private UUID networkId = NULL;

    public Map<UUID, String> getKnownNetworks() {
        return this.knownNetworks;
    }

    public void populateNetworks(Map<UUID, String> networks) {
        this.knownNetworks.clear();
        this.knownNetworks.putAll(networks);
    }

    public void setNetworkId(UUID networkId) {
        ServerData currentServer;
        this.networkId = networkId;
        if (this.artNetClient != null) {
            this.artNetClient.networkChange();
        }
        if ((currentServer = Minecraft.getInstance().getCurrentServer()) != null) {
            SavedClientNetworkManager.getInstance().saveNetworkForIP(currentServer.ip, networkId);
        } else if (Minecraft.getInstance().getSingleplayerServer() != null) {
            ArtNetToNetworkClientData instance = ArtNetToNetworkClientData.getInstance((Level)Minecraft.getInstance().getSingleplayerServer().overworld());
            instance.setNetworkId(networkId);
        }
    }

    public UUID getNetworkId() {
        return this.networkId;
    }

    public UUID getSavedNetworkID() {
        ServerData currentServer = Minecraft.getInstance().getCurrentServer();
        if (currentServer != null) {
            UUID networkFromIP = SavedClientNetworkManager.getInstance().getNetworkFromIP(currentServer.ip);
            if (networkFromIP != null) {
                return networkFromIP;
            }
        } else if (Minecraft.getInstance().getSingleplayerServer() != null) {
            ArtNetToNetworkClientData instance = ArtNetToNetworkClientData.getInstance((Level)Minecraft.getInstance().getSingleplayerServer().overworld());
            return instance.getNetworkId();
        }
        return NULL;
    }

    public TheatricalArtNetClient getClient() {
        if (this.artNetClient == null) {
            this.artNetClient = this.newClient();
        }
        return this.artNetClient;
    }

    private TheatricalArtNetClient newClient() {
        try {
            InetAddress byName = InetAddress.getByName(TheatricalConfig.INSTANCE.CLIENT.artNetIP);
            this.networkId = this.getSavedNetworkID();
            TheatricalArtNetClient client = new TheatricalArtNetClient(byName, this);
            client.start(byName);
            return client;
        }
        catch (UnknownHostException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public void shutdownAll() {
        this.knownNetworks.clear();
        if (this.artNetClient == null) {
            return;
        }
        this.artNetClient.stop();
        this.artNetClient = null;
    }
}

