/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.dmx;

import dev.imabad.theatrical.util.UUIDUtil;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ArtNetToNetworkClientData
extends SavedData {
    private static ArtNetToNetworkClientData INSTANCE;
    private static final String KEY = "artnet_network_map";
    private static final SavedData.Factory<ArtNetToNetworkClientData> factory;
    private UUID networkId = UUIDUtil.NULL;

    public static void unload() {
        INSTANCE = null;
    }

    public static ArtNetToNetworkClientData getInstance(Level level) {
        if (INSTANCE == null) {
            INSTANCE = (ArtNetToNetworkClientData)level.getServer().overworld().getDataStorage().computeIfAbsent(factory, KEY);
        }
        return INSTANCE;
    }

    public static ArtNetToNetworkClientData read(CompoundTag tag) {
        ArtNetToNetworkClientData data = new ArtNetToNetworkClientData();
        if (tag.contains("networkId")) {
            data.setNetworkId(tag.getUUID("networkId"));
        }
        return data;
    }

    public UUID getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(UUID networkId) {
        this.networkId = networkId;
        this.setDirty(true);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.putUUID("networkId", this.networkId);
        return compoundTag;
    }

    static {
        factory = new SavedData.Factory(ArtNetToNetworkClientData::new, ArtNetToNetworkClientData::read, null);
    }
}

