/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.blockentities.control.BasicLightingDeskBlockEntity;
import dev.imabad.theatrical.client.gui.widgets.FaderWidget;
import dev.imabad.theatrical.net.ControlGo;
import dev.imabad.theatrical.net.ControlModeToggle;
import dev.imabad.theatrical.net.ControlMoveStep;
import dev.imabad.theatrical.net.ControlUpdateFader;
import dev.imabad.theatrical.net.UpdateNetworkId;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BasicLightingDeskScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/lighting_console.png");
    private int imageWidth = 244;
    private int imageHeight = 126;
    private int xCenter;
    private int yCenter;
    private BasicLightingDeskBlockEntity be;
    private EditBox fadeInTime;
    private EditBox fadeOutTime;
    private UUID networkId;

    public BasicLightingDeskScreen(BasicLightingDeskBlockEntity blockEntity) {
        super((Component)Component.translatable((String)"screen.basicLightingDesk"));
        this.be = blockEntity;
        this.networkId = this.be.getNetworkId();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderWindow(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        this.renderLabel(guiGraphics, "ui.control.step", 20, 57, this.be.getCurrentStep());
        this.renderLabel(guiGraphics, this.be.isRunMode() ? "ui.control.modes.run" : "ui.control.modes.program", 41, 90, new Object[0]);
        this.renderLabel(guiGraphics, "ui.control.cues", 100, 5, new Object[0]);
        for (int key : this.be.getStoredSteps().keySet()) {
            this.renderLabel(guiGraphics, "ui.control.cue", 101, 15 + 10 * key, key);
        }
        this.renderLabel(guiGraphics, "ui.control.fadeIn", 35, 10, new Object[0]);
        this.renderLabel(guiGraphics, "ui.control.fadeOut", 35, 33, new Object[0]);
    }

    private void renderLabel(GuiGraphics guiGraphics, String translationKey, int offSetX, int offSetY, Object ... replacements) {
        guiGraphics.pose().pushPose();
        MutableComponent translatable = Component.translatable((String)translationKey, (Object[])replacements);
        guiGraphics.drawString(this.font, (Component)translatable, this.xCenter + this.imageWidth / 2 - this.font.width(translatable.getString()) / 2 + offSetX, this.yCenter + offSetY, 0x404040, false);
        guiGraphics.pose().popPose();
    }

    protected void init() {
        super.init();
        this.xCenter = (this.width - this.imageWidth) / 2;
        this.yCenter = (this.height - this.imageHeight) / 2;
        byte[] faders = this.be.getFaders();
        for (int i = 0; i < faders.length; ++i) {
            int baseY = this.yCenter + 7;
            if (i >= 6) {
                baseY += i / 6 * 61;
            }
            int faderNumber = i - i / 6 * 6;
            this.addRenderableWidget((GuiEventListener)new FaderWidget(this.xCenter + 7 + faderNumber * 20, baseY, i, Byte.toUnsignedInt(faders[i])));
        }
        this.addRenderableWidget((GuiEventListener)new FaderWidget(this.xCenter + 184, this.yCenter + 7, -1, Byte.toUnsignedInt(this.be.getGrandMaster())));
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"<-"), button -> this.moveStep(false)).pos(this.xCenter + 155, this.yCenter + 67).size(15, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"->"), button -> this.moveStep(true)).pos(this.xCenter + 170, this.yCenter + 67).size(15, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Go"), button -> this.go()).pos(this.xCenter + 130, this.yCenter + 100).size(20, 20).build());
        this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Mode"), button -> this.mode()).pos(this.xCenter + 155, this.yCenter + 100).size(30, 20).build());
        this.fadeInTime = new EditBox(this.font, this.xCenter + 147, this.yCenter + 20, 20, 10, (Component)Component.literal((String)"0"));
        this.fadeOutTime = new EditBox(this.font, this.xCenter + 147, this.yCenter + 43, 20, 10, (Component)Component.literal((String)"0"));
        this.fadeInTime.setValue(Integer.toString(this.be.getFadeInTicks()));
        this.fadeOutTime.setValue(Integer.toString(this.be.getFadeOutTicks()));
        this.addRenderableWidget((GuiEventListener)this.fadeInTime);
        this.addRenderableWidget((GuiEventListener)this.fadeOutTime);
        this.addRenderableWidget((GuiEventListener)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.literal((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.literal((String)"Unknown");
        }).withValues(CycleButton.ValueListSupplier.create((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).displayOnlyValue().withInitialValue((Object)this.networkId).create(this.xCenter + 45, this.yCenter + 130, 150, 20, (Component)Component.translatable((String)"screen.artnetconfig.network"), (obj, val) -> {
            this.networkId = val;
            new UpdateNetworkId(this.be.getBlockPos(), this.networkId).sendToServer();
        }));
    }

    private void moveStep(boolean forward) {
        new ControlMoveStep(this.be.getBlockPos(), forward).sendToServer();
    }

    private void go() {
        new ControlGo(this.be.getBlockPos(), Integer.parseInt(this.fadeInTime.getValue()), Integer.parseInt(this.fadeOutTime.getValue())).sendToServer();
    }

    private void mode() {
        new ControlModeToggle(this.be.getBlockPos()).sendToServer();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.children().forEach(widget -> {
            FaderWidget fader;
            if (widget instanceof FaderWidget && (fader = (FaderWidget)((Object)widget)).isMouseOver(mouseX, mouseY) && fader.isDragging()) {
                int newVal = fader.updateValue(mouseY);
                new ControlUpdateFader(this.be.getBlockPos(), fader.getChannel(), newVal).sendToServer();
            }
        });
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

