/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FaderWidget
extends AbstractWidget {
    private static final ResourceLocation background = new ResourceLocation("theatrical", "textures/gui/lighting_console.png");
    private final int channel;
    private int value;
    private boolean dragging = false;

    public FaderWidget(int x, int y, int channel, int value) {
        super(x, y, 10, 51, (Component)Component.empty());
        this.channel = channel;
        this.value = value;
    }

    public int getChannel() {
        return this.channel;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
        RenderSystem.disableDepthTest();
        guiGraphics.blit(background, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0.0f, 126.0f, 10, 51, 256, 256);
        guiGraphics.blit(background, this.getX() + 1, this.getY() + (this.height - 7) - (int)((float)this.value / 255.0f * 50.0f), 8, 11, 10.0f, 126.0f, 8, 11, 256, 256);
        RenderSystem.enableDepthTest();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void onClick(double mouseX, double mouseY) {
        this.value = this.calculateNewValue(mouseY);
        this.dragging = true;
    }

    public void onRelease(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public int calculateNewValue(double mouseY) {
        return (int)(((double)this.height - (mouseY - (double)this.getY())) / (double)this.height * 255.0);
    }

    public int updateValue(double mouseY) {
        this.value = this.calculateNewValue(mouseY);
        return this.value;
    }
}

