/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.widgets;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class LabeledEditBox
extends EditBox {
    private float alignX = 0.5f;
    private Font font;
    private int color = 0x404040;
    private boolean shadow = false;
    private int textOffsetY = 0;

    public LabeledEditBox(Font font, int width, int height, Component message) {
        super(font, width, height, message);
        this.width = width + 10;
        this.font = font;
    }

    public LabeledEditBox(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
        this.font = font;
    }

    public LabeledEditBox(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component message) {
        super(font, x, y, width, height, editBox, message);
        this.font = font;
    }

    public int getHeight() {
        return super.getHeight();
    }

    private LabeledEditBox horizontalAlignment(float horizontalAlignment) {
        this.alignX = horizontalAlignment;
        return this;
    }

    public LabeledEditBox alignLeft() {
        return this.horizontalAlignment(0.0f);
    }

    public LabeledEditBox alignCenter() {
        return this.horizontalAlignment(0.5f);
    }

    public LabeledEditBox alignRight() {
        return this.horizontalAlignment(1.0f);
    }

    public LabeledEditBox color(int color) {
        this.color = color;
        return this;
    }

    public LabeledEditBox shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public LabeledEditBox textOffsetY(int textOffsetY) {
        this.textOffsetY = textOffsetY;
        return this;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), 0xFFFFFF);
        Component component = this.getMessage();
        int i = this.getWidth();
        int j = this.font.width((FormattedText)component);
        int k = this.getX() + Math.round(this.alignX * (float)(i - j));
        int l = this.getY() + (this.getHeight() - 9) / 2 + this.textOffsetY;
        FormattedCharSequence formattedCharSequence = component.getVisualOrderText();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, formattedCharSequence, k, l - 9, this.color, this.shadow);
    }

    private FormattedCharSequence clipText(Component message, int width) {
        Font font = this.font;
        FormattedText formattedText = font.substrByWidth((FormattedText)message, width - font.width((FormattedText)CommonComponents.ELLIPSIS));
        return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{formattedText, CommonComponents.ELLIPSIS}));
    }
}

