/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.imabad.theatrical.commands.DMXNetworkModeArgument;
import dev.imabad.theatrical.commands.MemberRoleArgument;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.dmx.DMXNetworkMember;
import dev.imabad.theatrical.dmx.DMXNetworkMemberRole;
import dev.imabad.theatrical.dmx.DMXNetworkMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class NetworkCommand {
    private static final SimpleCommandExceptionType ERROR_NETWORK_DOES_NOT_EXIST = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.network.notfound"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"theatrical").then(Commands.literal((String)"networks").executes(NetworkCommand::listNetworks))).then(((LiteralArgumentBuilder)Commands.literal((String)"network").then(Commands.literal((String)"new").then(Commands.argument((String)"mode", (ArgumentType)DMXNetworkModeArgument.networkMode()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(NetworkCommand::createNetwork))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggest(NetworkCommand.getNetworksForPlayer((CommandContext<CommandSourceStack>)commandContext).stream().map(serverPlayer -> serverPlayer.id().toString()), (SuggestionsBuilder)suggestionsBuilder)).executes(NetworkCommand::getNetwork)).then(Commands.literal((String)"members").executes(NetworkCommand::listNetworkMembers))).then(Commands.literal((String)"rename").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(NetworkCommand::renameNetwork)))).then(Commands.literal((String)"delete").executes(NetworkCommand::deleteNetwork))).then(Commands.literal((String)"mode").then(Commands.argument((String)"mode", (ArgumentType)DMXNetworkModeArgument.networkMode()).executes(NetworkCommand::changeNetworkMode)))).then(Commands.literal((String)"setrole").then(Commands.argument((String)"target", (ArgumentType)GameProfileArgument.gameProfile()).suggests((commandContext, suggestionsBuilder) -> {
            Set<DMXNetworkMember> members = NetworkCommand.getDMXNetwork((CommandContext<CommandSourceStack>)commandContext).members();
            GameProfileCache profileCache = ((CommandSourceStack)commandContext.getSource()).getServer().getProfileCache();
            return SharedSuggestionProvider.suggest(members.stream().map(serverPlayer -> profileCache.get(serverPlayer.playerId()).orElse(new GameProfile(serverPlayer.playerId(), serverPlayer.playerId().toString())).getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).then(Commands.argument((String)"role", (ArgumentType)MemberRoleArgument.memberRole()).executes(NetworkCommand::changeMemberRole))))).then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((commandContext, suggestionsBuilder) -> {
            PlayerList playerList = ((CommandSourceStack)commandContext.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerList.getPlayers().stream().map(serverPlayer -> serverPlayer.getGameProfile().getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(NetworkCommand::addPlayer)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)GameProfileArgument.gameProfile()).suggests((commandContext, suggestionsBuilder) -> {
            Set<DMXNetworkMember> members = NetworkCommand.getDMXNetwork((CommandContext<CommandSourceStack>)commandContext).members();
            GameProfileCache profileCache = ((CommandSourceStack)commandContext.getSource()).getServer().getProfileCache();
            return SharedSuggestionProvider.suggest(members.stream().map(serverPlayer -> profileCache.get(serverPlayer.playerId()).orElse(new GameProfile(serverPlayer.playerId(), serverPlayer.playerId().toString())).getName()), (SuggestionsBuilder)suggestionsBuilder);
        }).executes(NetworkCommand::removePlayer))))));
    }

    private static int changeMemberRole(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        Collection players = GameProfileArgument.getGameProfiles(context, (String)"target");
        DMXNetworkMemberRole role = MemberRoleArgument.getMode(context, "role");
        for (GameProfile player : players) {
            dmxNetwork.setMemberRole(player.getId(), role);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.updated"), false);
        return 0;
    }

    private static int changeNetworkMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        DMXNetworkMode mode = DMXNetworkModeArgument.getMode(context, "mode");
        DMXNetworkMode oldMode = dmxNetwork.mode();
        dmxNetwork.setMode(mode);
        ArrayList<UUID> members = new ArrayList<UUID>();
        for (DMXNetworkMember member : dmxNetwork.members()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(member.playerId());
            if (player == null) continue;
            DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).notifyNetworks((Player)player);
            members.add(player.getUUID());
        }
        if (dmxNetwork.mode() == DMXNetworkMode.PUBLIC || oldMode == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                if (members.contains(player.getUUID())) continue;
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld()).notifyNetworks((Player)player);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.updated"), false);
        return 1;
    }

    private static int createNetwork(CommandContext<CommandSourceStack> context) {
        String newName = StringArgumentType.getString(context, (String)"name");
        DMXNetworkMode mode = DMXNetworkModeArgument.getMode(context, "mode");
        DMXNetwork network = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld()).createNetwork(newName, mode);
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            network.addMember(((CommandSourceStack)context.getSource()).getPlayer().getUUID(), DMXNetworkMemberRole.ADMIN);
        }
        if (network.mode() == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld()).notifyNetworks((Player)player);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.created"), false);
        return 1;
    }

    private static int listNetworkMembers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        GameProfileCache profileCache = ((CommandSourceStack)context.getSource()).getServer().getProfileCache();
        List<String> list = dmxNetwork.members().stream().map(DMXNetworkMember::playerId).map(playerUUID -> new Tuple(playerUUID, (Object)profileCache.get(playerUUID))).map(uuidOptionalTuple -> ((Optional)uuidOptionalTuple.getB()).isPresent() ? ((GameProfile)((Optional)uuidOptionalTuple.getB()).get()).getName() : ((UUID)uuidOptionalTuple.getA()).toString()).toList();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.members", (Object[])new Object[]{list.size(), String.join((CharSequence)", ", list)}), false);
        return 1;
    }

    private static int getNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        int i = 0;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network", (Object[])new Object[]{Component.literal((String)dmxNetwork.name()), dmxNetwork.id().toString(), dmxNetwork.members().size()}), false);
        return i;
    }

    private static int addPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        int i = 0;
        Collection players = GameProfileArgument.getGameProfiles(context, (String)"targets");
        for (GameProfile player : players) {
            if (dmxNetwork.isMember(player.getId())) continue;
            dmxNetwork.addMember(player.getId(), DMXNetworkMemberRole.NONE);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.members.add.success", (Object[])new Object[]{Component.literal((String)player.getName())}), false);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(player.getId());
            if (serverPlayer != null) {
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).notifyNetworks((Player)serverPlayer);
            }
            ++i;
        }
        return i;
    }

    private static int renameNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        String newName = StringArgumentType.getString(context, (String)"name");
        dmxNetwork.setName(newName);
        ArrayList<UUID> members = new ArrayList<UUID>();
        for (DMXNetworkMember member : dmxNetwork.members()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(member.playerId());
            if (player == null) continue;
            DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).notifyNetworks((Player)player);
            members.add(player.getUUID());
        }
        if (dmxNetwork.mode() == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                if (members.contains(player.getUUID())) continue;
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld()).notifyNetworks((Player)player);
            }
        }
        return 1;
    }

    private static int deleteNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).deleteNetwork(dmxNetwork);
        ArrayList<UUID> members = new ArrayList<UUID>();
        for (DMXNetworkMember member : dmxNetwork.members()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(member.playerId());
            if (player == null) continue;
            DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).notifyNetworks((Player)player);
            members.add(player.getUUID());
        }
        if (dmxNetwork.mode() == DMXNetworkMode.PUBLIC) {
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                if (members.contains(player.getUUID())) continue;
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld()).notifyNetworks((Player)player);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.deleted"), false);
        return 1;
    }

    private static int removePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetwork dmxNetwork = NetworkCommand.getDMXNetwork(context);
        if (!NetworkCommand.isSourceOperator(context) && ((CommandSourceStack)context.getSource()).isPlayer() && !dmxNetwork.isAdmin(((CommandSourceStack)context.getSource()).getPlayer().getUUID())) {
            throw ERROR_NETWORK_DOES_NOT_EXIST.create();
        }
        Collection players = GameProfileArgument.getGameProfiles(context, (String)"targets");
        for (GameProfile player : players) {
            if (!dmxNetwork.isMember(player.getId())) continue;
            dmxNetwork.removeMember(player.getId());
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(player.getId());
            if (serverPlayer != null) {
                DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getLevel()).notifyNetworks((Player)serverPlayer);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.network.members.remove.success", (Object[])new Object[]{Component.literal((String)player.getName())}), false);
        }
        return 0;
    }

    private static Collection<DMXNetwork> getNetworksForPlayer(CommandContext<CommandSourceStack> context) {
        DMXNetworkData instance = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld());
        if (NetworkCommand.isSourceOperator(context)) {
            return instance.getAllNetworks();
        }
        return instance.getNetworksForPlayer(((CommandSourceStack)context.getSource()).getPlayer().getUUID());
    }

    private static int listNetworks(CommandContext<CommandSourceStack> context) {
        DMXNetworkData instance = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld());
        List networks = NetworkCommand.isSourceOperator(context) ? instance.getAllNetworks().stream().map(DMXNetwork::name).collect(Collectors.toList()) : instance.getNetworksForPlayer(((CommandSourceStack)context.getSource()).getPlayer().getUUID()).stream().map(DMXNetwork::name).collect(Collectors.toList());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.networks", (Object[])new Object[]{networks.size(), String.join((CharSequence)", ", networks)}), false);
        return 1;
    }

    private static boolean isSourceOperator(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).hasPermission(((CommandSourceStack)context.getSource()).getServer().getOperatorUserPermissionLevel());
    }

    private static DMXNetwork getDMXNetwork(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        DMXNetworkData instance = DMXNetworkData.getInstance((Level)((CommandSourceStack)context.getSource()).getServer().overworld());
        try {
            String id = (String)context.getArgument("id", String.class);
            UUID uuid = UUID.fromString(id);
            DMXNetwork network = instance.getNetwork(uuid);
            if (network != null) {
                return network;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw ERROR_NETWORK_DOES_NOT_EXIST.create();
    }
}

