/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.fixtures;

import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.api.HangType;
import dev.imabad.theatrical.api.dmx.DMXPersonality;
import dev.imabad.theatrical.blocks.light.BaseLightBlock;
import dev.imabad.theatrical.fixtures.SharedSlots;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LEDFresnelFixture
extends Fixture {
    private static final List<DMXPersonality> PERSONALITIES = Collections.singletonList(new DMXPersonality(4, "4-Channel Mode").addSlot(SharedSlots.INTENSITY).addSlot(SharedSlots.RED).addSlot(SharedSlots.GREEN).addSlot(SharedSlots.BLUE));
    private static final ResourceLocation TILT_MODEL = new ResourceLocation("theatrical", "block/fresnel/fresnel_body_only");
    private static final ResourceLocation PAN_MODEL = new ResourceLocation("theatrical", "block/fresnel/fresnel_handle_only");
    private static final ResourceLocation STATIC_MODEL = new ResourceLocation("theatrical", "block/fresnel/fresnel_hook_bar");
    private final float[] tiltRotation = new float[]{0.5f, 0.3f, 0.39f};
    private final float[] panRotation = new float[]{0.5f, 0.0f, 0.41f};
    private final float[] beamStartPosition = new float[]{0.5f, 0.24f, 0.1f};

    @Override
    public ResourceLocation getTiltModel() {
        return TILT_MODEL;
    }

    @Override
    public ResourceLocation getPanModel() {
        return PAN_MODEL;
    }

    @Override
    public ResourceLocation getStaticModel() {
        return STATIC_MODEL;
    }

    @Override
    public float[] getTiltRotationPosition() {
        return this.tiltRotation;
    }

    @Override
    public float[] getPanRotationPosition() {
        return this.panRotation;
    }

    @Override
    public float[] getBeamStartPosition() {
        return this.beamStartPosition;
    }

    @Override
    public float getDefaultRotation() {
        return 0.0f;
    }

    @Override
    public float getBeamWidth() {
        return 0.15f;
    }

    @Override
    public float getRayTraceRotation() {
        return 180.0f;
    }

    @Override
    public HangType getHangType() {
        return HangType.HOOK_BAR;
    }

    @Override
    public float[] getTransforms(BlockState fixtureBlockState, BlockState supportBlockState) {
        if (fixtureBlockState.getValue((Property)BaseLightBlock.HANG_DIRECTION) == Direction.UP) {
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        return new float[]{0.0f, 0.5f, 0.0f};
    }

    @Override
    public List<DMXPersonality> getDMXPersonalities() {
        return PERSONALITIES;
    }

    @Override
    public boolean invertTilt() {
        return true;
    }

    @Override
    public boolean invertPan() {
        return true;
    }

    @Override
    public double getLightRadius() {
        return 2.0;
    }
}

