/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.neoforge;

import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.blocks.rigging.TankTrapBlock;
import dev.imabad.theatrical.items.Items;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataEvent {
    public static void onData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        gen.addProvider(event.includeClient(), (DataProvider)new BlockState(output, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new Item(output, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new Lang(output, "en_us"));
    }

    public static class BlockState
    extends BlockStateProvider {
        public BlockState(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "theatrical", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)Blocks.ART_NET_INTERFACE.get());
            this.simpleBlock((Block)Blocks.REDSTONE_INTERFACE.get());
            ModelFile.ExistingModelFile trussModel = this.models().getExistingFile(new ResourceLocation("theatrical:block/truss"));
            this.axisBlock((RotatedPillarBlock)Blocks.TRUSS_BLOCK.get(), (ModelFile)trussModel, (ModelFile)trussModel);
            this.horizontalBlock((Block)Blocks.BASIC_LIGHTING_DESK.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("theatrical:block/lighting_console")));
            this.getVariantBuilder((Block)Blocks.TANK_TRAP.get()).forAllStates(blockState -> {
                ModelFile.ExistingModelFile file = this.models().getExistingFile(new ResourceLocation("theatrical:block/tank_trap"));
                if (((Boolean)blockState.getValue((Property)TankTrapBlock.HAS_PIPE)).booleanValue()) {
                    file = this.models().getExistingFile(new ResourceLocation("theatrical:block/tank_trap_with_pipe"));
                }
                return ConfiguredModel.builder().modelFile((ModelFile)file).build();
            });
        }
    }

    public static class Item
    extends ItemModelProvider {
        public Item(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "theatrical", existingFileHelper);
        }

        protected void registerModels() {
            this.cubeAll(Blocks.ART_NET_INTERFACE.getId().getPath(), new ResourceLocation("theatrical", "block/artnet_interface"));
            this.cubeAll(Blocks.REDSTONE_INTERFACE.getId().getPath(), new ResourceLocation("theatrical", "block/redstone_interface"));
            this.withExistingParent(Blocks.PIPE_BLOCK.getId().getPath(), new ResourceLocation("theatrical", "block/vertical_pipe"));
            this.withExistingParent(Blocks.TRUSS_BLOCK.getId().getPath(), new ResourceLocation("theatrical", "block/truss"));
            this.withExistingParent(Blocks.MOVING_LIGHT_BLOCK.getId().getPath(), new ResourceLocation("theatrical", "block/moving_light/moving_head_whole"));
            this.withExistingParent(Blocks.MOVING_WASH_BLOCK.getId().getPath(), new ResourceLocation("theatrical", "block/moving_wash/moving_wash_whole"));
            this.withExistingParent(Blocks.LED_FRESNEL.getId().getPath(), new ResourceLocation("theatrical", "block/fresnel/fresnel_whole"));
            this.withExistingParent(Blocks.TANK_TRAP.getId().getPath(), new ResourceLocation("theatrical", "block/tank_trap"));
            this.withExistingParent(Blocks.LED_PANEL.getId().getPath(), new ResourceLocation("theatrical", "block/led_panel"));
            this.withExistingParent(Blocks.BASIC_LIGHTING_DESK.getId().getPath(), new ResourceLocation("theatrical", "block/lighting_console"));
            ((ItemModelBuilder)this.withExistingParent(Items.CONFIGURATION_CARD.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", new ResourceLocation("theatrical", "item/configuration_card"));
        }
    }

    public static class Lang
    extends LanguageProvider {
        public Lang(PackOutput output, String locale) {
            super(output, "theatrical", locale);
        }

        protected void addTranslations() {
            this.addBlock((Supplier)Blocks.ART_NET_INTERFACE, "ArtNet Interface");
            this.addBlock((Supplier)Blocks.MOVING_LIGHT_BLOCK, "Moving Light");
            this.addBlock((Supplier)Blocks.MOVING_WASH_BLOCK, "Moving Wash");
            this.addBlock((Supplier)Blocks.PIPE_BLOCK, "Rigging Pipe");
            this.addBlock((Supplier)Blocks.LED_FRESNEL, "LED Fresnel");
            this.addBlock((Supplier)Blocks.TRUSS_BLOCK, "MT100 Truss");
            this.addBlock((Supplier)Blocks.REDSTONE_INTERFACE, "Redstone Interface");
            this.addBlock((Supplier)Blocks.TANK_TRAP, "Tank Trap");
            this.addBlock((Supplier)Blocks.LED_PANEL, "LED Panel");
            this.addBlock((Supplier)Blocks.BASIC_LIGHTING_DESK, "Basic Lighting Desk");
            this.addItem((Supplier)Items.CONFIGURATION_CARD, "Configuration Card");
            this.add("itemGroup.theatrical", "Theatrical");
            this.add("artneti.dmxUniverse", "Network Universe");
            this.add("artneti.ipAddress", "IP Address");
            this.add("artneti.save", "Save");
            this.add("artneti.notConnected", "No data received");
            this.add("artneti.notAuthorized", "You're not authorized!");
            this.add("artneti.lastReceived", "Data received %d second(s) ago");
            this.add("fixture.dmxStart", "Start address");
            this.add("fixture.pan", "Pan");
            this.add("fixture.tilt", "Tilt");
            this.add("screen.movinglight", "Moving Light");
            this.add("button.artnetconfig", "ArtNet Config");
            this.add("screen.artnetconfig.enabled", "ArtNet Enabled: %s");
            this.add("ui.control.step", "Step - %s");
            this.add("ui.control.modes.run", "Run Mode");
            this.add("ui.control.modes.program", "Program Mode");
            this.add("ui.control.cues", "Cues");
            this.add("ui.control.cue", "Cue - %s");
            this.add("ui.control.fadeIn", "Fade in");
            this.add("ui.control.fadeOut", "Fade out");
            this.add("commands.network.notfound", "Network not found.");
            this.add("commands.networks", "There are %s network(s): %s.");
            this.add("commands.network.members", "There are %s network member(s): %s.");
            this.add("commands.network.members.add.success", "Added %s to the network.");
            this.add("commands.network.members.add.failed", "Player already member of network.");
            this.add("commands.network.members.remove.success", "Removed %s from the network.");
            this.add("commands.network", "%s (%s) has %s member(s)");
            this.add("commands.network.invalid", "Unknown network mode: %s");
            this.add("commands.network.role.invalid", "Unknown member role: %s");
            this.add("commands.network.created", "Network created");
            this.add("commands.network.deleted", "Network deleted");
            this.add("commands.network.updated", "Network updated");
            this.add("screen.configurationcard.autoincrement", "Address Auto Increment");
            this.add("screen.configurationcard", "Configuration Card");
            this.add("screen.artnetconfig.network", "Network");
            this.add("screen.artnetconfig.entry", "Subnet: %s Universe: %s");
            this.add("item.configurationcard.success", "Configured device to %s network, universe %s and address %s - next address is %s.");
            this.add("screen.artnetconfig.entry.subnet", "Subnet: %s");
            this.add("screen.artnetconfig.entry.universe", "Universe: %s");
            this.add("screen.artnetconfig.subnet", "Art-Net Subnet");
            this.add("screen.artnetconfig.universe", "Art-Net Universe");
            this.add("screen.artnetconfig.networkUniverse", "Network Universe");
            this.add("screen.artnetconfig.networkEnabled", "Enabled");
            this.add("item.configurationcard.description.1", "Shift + Right Click for settings");
            this.add("item.configurationcard.description.2", "Right click on fixture to apply");
        }
    }
}

