/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.items.Items;
import dev.imabad.theatrical.net.TheatricalNet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ConfigureConfigurationCard
extends BaseC2SMessage {
    private UUID network;
    private int dmxAddress;
    private int dmxUniverse;
    private boolean autoIncrement;
    private boolean universeEnabled;
    private boolean addressEnabled;

    public ConfigureConfigurationCard(UUID network, int dmxAddress, int dmxUniverse, boolean autoIncrement, boolean universeEnabled, boolean addressEnabled) {
        this.network = network;
        this.dmxAddress = dmxAddress;
        this.dmxUniverse = dmxUniverse;
        this.autoIncrement = autoIncrement;
        this.universeEnabled = universeEnabled;
        this.addressEnabled = addressEnabled;
    }

    public ConfigureConfigurationCard(FriendlyByteBuf buf) {
        this.network = buf.readUUID();
        this.dmxAddress = buf.readInt();
        this.dmxUniverse = buf.readInt();
        this.autoIncrement = buf.readBoolean();
        this.universeEnabled = buf.readBoolean();
        this.addressEnabled = buf.readBoolean();
    }

    public MessageType getType() {
        return TheatricalNet.CONFIGURE_CONFIGURATION_CARD;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.network);
        buf.writeInt(this.dmxAddress);
        buf.writeInt(this.dmxUniverse);
        buf.writeBoolean(this.autoIncrement);
        buf.writeBoolean(this.universeEnabled);
        buf.writeBoolean(this.addressEnabled);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player player = context.getPlayer();
            ItemStack itemStack = null;
            if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Items.CONFIGURATION_CARD.get()) {
                itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
            } else if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() == Items.CONFIGURATION_CARD.get()) {
                itemStack = player.getItemInHand(InteractionHand.OFF_HAND);
            }
            if (itemStack != null) {
                CompoundTag dataTag = itemStack.getOrCreateTag();
                dataTag.putUUID("network", this.network);
                dataTag.putInt("dmxUniverse", this.dmxUniverse);
                dataTag.putInt("dmxAddress", this.dmxAddress);
                dataTag.putBoolean("autoIncrement", this.autoIncrement);
                dataTag.putBoolean("universeEnabled", this.universeEnabled);
                dataTag.putBoolean("addressEnabled", this.addressEnabled);
                itemStack.save(dataTag);
            }
        });
    }
}

