/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.blockentities.control.BasicLightingDeskBlockEntity;
import dev.imabad.theatrical.net.TheatricalNet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ControlGo
extends BaseC2SMessage {
    private final BlockPos blockPos;
    private final int fadeInTicks;
    private final int fadeOutTicks;

    public ControlGo(BlockPos blockPos, int fadeInTicks, int fadeOutTicks) {
        this.blockPos = blockPos;
        this.fadeInTicks = fadeInTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    ControlGo(FriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.fadeInTicks = buf.readInt();
        this.fadeOutTicks = buf.readInt();
    }

    public MessageType getType() {
        return TheatricalNet.CONTROL_GO;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeInt(this.fadeInTicks);
        buf.writeInt(this.fadeOutTicks);
    }

    public void handle(NetworkManager.PacketContext context) {
        BlockEntity be = context.getPlayer().level().getBlockEntity(this.blockPos);
        if (be instanceof BasicLightingDeskBlockEntity) {
            BasicLightingDeskBlockEntity lightingDeskBlock = (BasicLightingDeskBlockEntity)be;
            if (!lightingDeskBlock.isRunMode()) {
                lightingDeskBlock.setFadeInTicks(this.fadeInTicks);
                lightingDeskBlock.setFadeOutTicks(this.fadeOutTicks);
            }
            lightingDeskBlock.clickButton();
        }
    }
}

