/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.blockentities.light.BaseLightBlockEntity;
import dev.imabad.theatrical.net.TheatricalNet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateFixturePosition
extends BaseC2SMessage {
    private BlockPos pos;
    private int tilt;
    private int pan;

    public UpdateFixturePosition(BlockPos blockPos, int tilt, int pan) {
        this.pos = blockPos;
        this.tilt = tilt;
        this.pan = pan;
    }

    UpdateFixturePosition(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.tilt = buf.readInt();
        this.pan = buf.readInt();
    }

    public MessageType getType() {
        return TheatricalNet.UPDATE_FIXTURE_POS;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.tilt);
        buf.writeInt(this.pan);
    }

    public void handle(NetworkManager.PacketContext context) {
        BlockEntity be = context.getPlayer().level().getBlockEntity(this.pos);
        if (be instanceof BaseLightBlockEntity) {
            BaseLightBlockEntity baseLightBlockEntity = (BaseLightBlockEntity)be;
            baseLightBlockEntity.setPan(this.pan);
            baseLightBlockEntity.setTilt(this.tilt);
        }
    }
}

