/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.control;

import dev.imabad.theatrical.api.dmx.BelongsToNetwork;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BasicLightingDeskBlockEntity
extends ClientSyncBlockEntity
implements BelongsToNetwork {
    private int ticks = 0;
    private byte[] faders = new byte[12];
    private final byte[] actualDMX = new byte[12];
    private int currentStep = 0;
    private HashMap<Integer, StoredCue> storedSteps = new HashMap();
    private StoredCue activeCue;
    private boolean isRunMode = false;
    private int fadeInTicks = 0;
    private int fadeOutTicks = 0;
    private int fadeInTicksRemaining = 0;
    private int fadeOutTicksRemaining = 0;
    private byte[] perTickOut;
    private byte[] perTickIn;
    private boolean isFadingOut = false;
    private byte grandMaster = (byte)-1;
    private UUID networkId = UUIDUtil.NULL;
    private int universe = 0;

    public BasicLightingDeskBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.BASIC_LIGHTING_DESK.get(), blockPos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        if (level.f_46443_) {
            return;
        }
        if (be instanceof BasicLightingDeskBlockEntity) {
            BasicLightingDeskBlockEntity beL = (BasicLightingDeskBlockEntity)be;
            beL.tick();
        }
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks >= 1) {
            if (this.isFadingOut) {
                if (this.fadeOutTicksRemaining > 0) {
                    --this.fadeOutTicksRemaining;
                    this.doFadeTickOut();
                } else {
                    this.isFadingOut = false;
                }
            } else if (this.fadeInTicksRemaining > 0) {
                --this.fadeInTicksRemaining;
                this.doFadeTickIn();
            }
            this.ticks = 0;
            byte[] dmx = new byte[512];
            for (int i = 0; i < this.faders.length; ++i) {
                dmx[i] = (byte)(this.convertByteToInt(this.faders[i]) * (this.convertByteToInt(this.grandMaster) / 255.0f));
            }
            this.update(dmx);
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void update(byte[] data) {
        Collection<DMXConsumer> consumers;
        DMXNetwork dmxData;
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null && (dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId)) != null && (consumers = dmxData.getConsumers(this.universe)) != null) {
            consumers.forEach(consumer -> consumer.consume(data));
        }
    }

    public float convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public byte[] getFaders() {
        return this.faders;
    }

    @Override
    public void write(CompoundTag compoundTag) {
        if (compoundTag == null) {
            compoundTag = new CompoundTag();
        }
        compoundTag.m_128382_("faders", this.faders);
        CompoundTag compoundNBT = new CompoundTag();
        for (int key : this.storedSteps.keySet()) {
            compoundNBT.m_128365_(Integer.toString(key), (Tag)this.storedSteps.get(key).toNBT());
        }
        compoundTag.m_128365_("storedSteps", (Tag)compoundNBT);
        compoundTag.m_128405_("currentStep", this.currentStep);
        compoundTag.m_128344_("grandMaster", this.grandMaster);
        compoundTag.m_128379_("isRunMode", this.isRunMode);
        compoundTag.m_128405_("fadeInTicks", this.fadeInTicks);
        compoundTag.m_128405_("fadeOutTicks", this.fadeOutTicks);
        if (this.networkId != null) {
            compoundTag.m_128362_("network", this.networkId);
        }
        compoundTag.m_128405_("universe", this.universe);
    }

    @Override
    public void read(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("faders")) {
            this.faders = compoundTag.m_128463_("faders");
        }
        if (compoundTag.m_128441_("storedSteps")) {
            this.storedSteps = new HashMap();
            CompoundTag compoundNBT = compoundTag.m_128469_("storedSteps");
            for (String key : compoundNBT.m_128431_()) {
                int stepNumber = Integer.parseInt(key);
                this.storedSteps.put(stepNumber, new StoredCue().fromNBT(compoundNBT.m_128469_(key)));
            }
        }
        if (compoundTag.m_128441_("currentStep")) {
            this.currentStep = compoundTag.m_128451_("currentStep");
        }
        if (compoundTag.m_128441_("grandMaster")) {
            this.grandMaster = compoundTag.m_128445_("grandMaster");
        }
        if (compoundTag.m_128441_("isRunMode")) {
            this.isRunMode = compoundTag.m_128471_("isRunMode");
        }
        if (compoundTag.m_128441_("fadeInTicks")) {
            this.fadeInTicks = compoundTag.m_128451_("fadeInTicks");
        }
        if (compoundTag.m_128441_("fadeOutTicks")) {
            this.fadeOutTicks = compoundTag.m_128451_("fadeOutTicks");
        }
        if (compoundTag.m_128441_("network")) {
            this.networkId = compoundTag.m_128342_("network");
        }
        if (compoundTag.m_128441_("universe")) {
            this.universe = compoundTag.m_128451_("universe");
        }
    }

    public void setFaders(byte[] faders) {
        this.faders = Arrays.copyOf(faders, faders.length);
        this.m_6596_();
    }

    public void setFader(int fader, int value) {
        if (fader != -1) {
            this.faders[fader] = (byte)value;
        } else {
            this.grandMaster = (byte)value;
        }
        this.m_6596_();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public byte getGrandMaster() {
        return this.grandMaster;
    }

    public boolean isRunMode() {
        return this.isRunMode;
    }

    public void toggleMode() {
        this.isRunMode = !this.isRunMode;
        this.m_6596_();
    }

    public void clickButton() {
        if (this.isRunMode()) {
            this.recallNextStep();
        } else {
            this.storeCurrentFaders();
        }
    }

    public void moveForward() {
        if (this.isRunMode) {
            this.currentStep = this.getNextStep();
        } else {
            ++this.currentStep;
            if (this.storedSteps.containsKey(this.currentStep)) {
                byte[] faders = this.storedSteps.get(this.currentStep).getFaders();
                this.setFaders(faders);
            }
        }
    }

    public void moveBack() {
        if (this.isRunMode) {
            this.currentStep = this.getPreviousStep();
        } else {
            if (this.currentStep - 1 < 0) {
                return;
            }
            --this.currentStep;
            if (this.storedSteps.containsKey(this.currentStep)) {
                byte[] faders = this.storedSteps.get(this.currentStep).getFaders();
                this.setFaders(faders);
            }
        }
    }

    public HashMap<Integer, StoredCue> getStoredSteps() {
        return this.storedSteps;
    }

    private void doFadeTickIn() {
        for (int i = 0; i < this.faders.length; ++i) {
            this.faders[i] = (byte)(this.faders[i] - this.perTickIn[i]);
        }
    }

    private void doFadeTickOut() {
        for (int i = 0; i < this.faders.length; ++i) {
            this.faders[i] = (byte)(this.faders[i] - this.perTickOut[i]);
        }
    }

    private void recallNextStep() {
        int i;
        if (this.storedSteps.size() < this.currentStep) {
            return;
        }
        StoredCue previousCue = this.activeCue;
        if (!this.storedSteps.containsKey(this.currentStep)) {
            return;
        }
        StoredCue storedCue = this.storedSteps.get(this.currentStep);
        if (previousCue != null && previousCue.fadeOutTicks > 0) {
            this.isFadingOut = true;
            this.fadeOutTicksRemaining = previousCue.getFadeOutTicks();
            this.perTickOut = new byte[12];
            for (i = 0; i < this.faders.length; ++i) {
                this.perTickOut[i] = (byte)(this.convertByteToInt(this.faders[i]) / (float)this.fadeOutTicksRemaining);
            }
        }
        if (storedCue.fadeInTicks > 0) {
            this.fadeInTicksRemaining = storedCue.getFadeInTicks();
            this.perTickIn = new byte[12];
            for (i = 0; i < this.faders.length; ++i) {
                this.perTickIn[i] = this.isFadingOut ? (byte)(-this.convertByteToInt(storedCue.getFaders()[i]) / (float)this.fadeInTicksRemaining) : (byte)((this.convertByteToInt(this.faders[i]) - this.convertByteToInt(storedCue.getFaders()[i])) / (float)this.fadeInTicksRemaining);
            }
        } else {
            byte[] faders = storedCue.getFaders();
            this.setFaders(faders);
        }
        this.activeCue = storedCue;
        this.currentStep = this.getNextStep();
        this.m_6596_();
    }

    private Integer getFirst() {
        return (Integer)this.storedSteps.keySet().stream().min(Integer::compareTo).get();
    }

    private Integer getNextStep() {
        if (this.storedSteps.size() > 0) {
            Optional<Integer> nextSteps = this.storedSteps.keySet().stream().filter(integer -> integer > this.currentStep).min(Integer::compareTo);
            return nextSteps.orElseGet(this::getFirst);
        }
        return this.currentStep;
    }

    private Integer getPreviousStep() {
        if (this.storedSteps.size() > 0) {
            Optional<Integer> nextSteps = this.storedSteps.keySet().stream().filter(integer -> integer < this.currentStep).sorted(Integer::compareTo).max(Comparator.naturalOrder());
            return nextSteps.orElseGet(() -> (Integer)this.storedSteps.keySet().stream().sorted(Integer::compareTo).max(Comparator.naturalOrder()).get());
        }
        return this.currentStep;
    }

    private void storeCurrentFaders() {
        StoredCue storedCue = new StoredCue(Arrays.copyOf(this.faders, this.faders.length), this.fadeInTicks, this.fadeOutTicks);
        this.storedSteps.put(this.currentStep, storedCue);
        ++this.currentStep;
        this.m_6596_();
    }

    public int getFadeInTicks() {
        return this.fadeInTicks;
    }

    public void setFadeInTicks(int fadeInTicks) {
        this.fadeInTicks = fadeInTicks;
    }

    public int getFadeOutTicks() {
        return this.fadeOutTicks;
    }

    public void setFadeOutTicks(int fadeOutTicks) {
        this.fadeOutTicks = fadeOutTicks;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(UUID newNetworkId) {
        if (newNetworkId == this.networkId) {
            return;
        }
        this.networkId = newNetworkId;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public static class StoredCue {
        private byte[] faders;
        private int fadeInTicks;
        private int fadeOutTicks;

        public StoredCue() {
        }

        public StoredCue(byte[] faders, int fadeInTicks, int fadeOutTicks) {
            this.faders = faders;
            this.fadeInTicks = fadeInTicks;
            this.fadeOutTicks = fadeOutTicks;
        }

        public CompoundTag toNBT() {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128382_("faders", this.faders);
            compoundNBT.m_128405_("fadeIn", this.fadeInTicks);
            compoundNBT.m_128405_("fadeOut", this.fadeOutTicks);
            return compoundNBT;
        }

        public StoredCue fromNBT(CompoundTag nbt) {
            this.faders = nbt.m_128463_("faders");
            this.fadeInTicks = nbt.m_128451_("fadeIn");
            this.fadeOutTicks = nbt.m_128451_("fadeOut");
            return this;
        }

        public byte[] getFaders() {
            return this.faders;
        }

        public int getFadeInTicks() {
            return this.fadeInTicks;
        }

        public int getFadeOutTicks() {
            return this.fadeOutTicks;
        }
    }
}

