/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.blockentities.light.BaseLightBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.util.RndUtils;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseDMXConsumerLightBlockEntity
extends BaseLightBlockEntity
implements DMXConsumer {
    private int channelCount;
    private int channelStartPoint;
    private int dmxUniverse;
    private RDMDeviceId deviceId;
    private UUID networkId = UUIDUtil.NULL;

    public BaseDMXConsumerLightBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        super.write(compoundTag);
        compoundTag.m_128405_("channelCount", this.channelCount);
        compoundTag.m_128405_("channelStartPoint", this.channelStartPoint);
        compoundTag.m_128405_("dmxUniverse", this.dmxUniverse);
        if (this.deviceId != null) {
            compoundTag.m_128382_("deviceId", this.deviceId.toBytes());
        }
        compoundTag.m_128362_("network", this.networkId);
    }

    @Override
    public void read(CompoundTag compoundTag) {
        super.read(compoundTag);
        this.channelCount = compoundTag.m_128451_("channelCount");
        this.channelStartPoint = compoundTag.m_128451_("channelStartPoint");
        if (compoundTag.m_128441_("dmxUniverse")) {
            this.dmxUniverse = compoundTag.m_128451_("dmxUniverse");
        }
        if (compoundTag.m_128441_("deviceId")) {
            this.deviceId = new RDMDeviceId(compoundTag.m_128463_("deviceId"));
        }
        if (compoundTag.m_128441_("network")) {
            this.networkId = compoundTag.m_128342_("network");
        }
    }

    private void generateDeviceId() {
        byte[] bytes = new byte[4];
        if (this.f_58857_ != null) {
            RndUtils.nextBytes(this.f_58857_.m_213780_(), bytes);
        } else {
            new Random().nextBytes(bytes);
        }
        this.deviceId = new RDMDeviceId(32752, bytes);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getChannelStart() {
        return this.channelStartPoint;
    }

    @Override
    public int getUniverse() {
        return this.dmxUniverse;
    }

    @Override
    public RDMDeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    public void setUniverse(int dmxUniverse) {
        if (this.dmxUniverse == dmxUniverse) {
            return;
        }
        this.removeConsumer();
        this.dmxUniverse = dmxUniverse;
        this.addConsumer();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount;
    }

    public void setChannelStartPoint(int channelStartPoint) {
        if (this.channelStartPoint == channelStartPoint) {
            return;
        }
        this.channelStartPoint = channelStartPoint;
        this.updateConsumer();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    private void updateConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.updateConsumer(this);
        }
    }

    private void removeConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.removeConsumer(this, this.m_58899_());
        }
    }

    private void addConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId);
        if (dmxData != null) {
            if (this.deviceId == null) {
                this.generateDeviceId();
            }
            dmxData.addConsumer(this.m_58899_(), this);
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level != null && !level.f_46443_) {
            this.addConsumer();
        }
    }

    @Override
    public void m_7651_() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.removeConsumer();
        }
        super.m_7651_();
    }

    @Override
    public void setNetworkId(UUID networkId) {
        if (networkId == this.networkId) {
            return;
        }
        this.removeConsumer();
        this.networkId = networkId;
        this.addConsumer();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }
}

