/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks;

import dev.imabad.theatrical.api.Support;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public abstract class HangableBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty BROKEN = BooleanProperty.m_61465_((String)"broken");
    public static final DirectionProperty HANG_DIRECTION = DirectionProperty.m_156003_((String)"hang_direction");
    public static final BooleanProperty HANGING = BooleanProperty.m_61465_((String)"hanging");

    protected HangableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BROKEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HANG_DIRECTION, (Comparable)Direction.UP)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{BROKEN}).m_61104_(new Property[]{HANG_DIRECTION}).m_61104_(new Property[]{HANGING});
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return this.isHanging(levelReader, blockPos);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        levelAccessor.m_183326_().m_183393_(new ScheduledTick((Object)this, blockPos, 3L, 0L));
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean isHanging(LevelReader levelReader, BlockPos pos) {
        BlockState blockState = levelReader.m_8055_(pos);
        if (!(blockState.m_60734_() instanceof HangableBlock)) {
            return false;
        }
        if (!blockState.m_60795_() && ((Boolean)blockState.m_61143_((Property)HANGING)).booleanValue()) {
            BlockPos offset = pos.m_121945_((Direction)blockState.m_61143_((Property)HANG_DIRECTION));
            return !levelReader.m_46859_(offset) && levelReader.m_8055_(offset).m_60734_() instanceof Support;
        }
        return false;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)BROKEN)).booleanValue() || !this.m_7898_(blockState, (LevelReader)serverLevel, blockPos)) {
            // empty if block
        }
    }

    public abstract Direction getLightFacing(Direction var1, Player var2);
}

