/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blocks.rigging;

import dev.imabad.theatrical.api.FixtureProvider;
import dev.imabad.theatrical.api.HangType;
import dev.imabad.theatrical.api.Support;
import dev.imabad.theatrical.blocks.Blocks;
import dev.imabad.theatrical.blocks.HangableBlock;
import dev.imabad.theatrical.blocks.light.BaseLightBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends DirectionalBlock
implements Support {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    private final VoxelShape Z_BOX = Shapes.m_83064_((AABB)new AABB(0.35, 0.4, 0.0, 0.65, 0.6, 1.0));
    private final VoxelShape Z_BOX_DOWN = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0));
    private final VoxelShape Z_BOX_UP = Shapes.m_83064_((AABB)new AABB(0.0, 0.4, 0.0, 1.0, 1.0, 1.0));
    private final VoxelShape X_BOX = Shapes.m_83064_((AABB)new AABB(0.0, 0.4, 0.4, 1.0, 0.6, 0.6));
    private final VoxelShape X_BOX_DOWN = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0));
    private final VoxelShape X_BOX_UP = Shapes.m_83064_((AABB)new AABB(0.0, 0.4, 0.0, 1.0, 1.0, 1.0));
    private final VoxelShape Y_BOX = Shapes.m_83064_((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 1.0, 0.6));
    private final VoxelShape Y_BOX_SOUTH = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.4, 1.0, 1.0, 1.0));
    private final VoxelShape Y_BOX_NORTH = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.6));
    private final VoxelShape Y_BOX_EAST = Shapes.m_83064_((AABB)new AABB(0.4, 0.0, 0.0, 1.0, 1.0, 1.0));
    private final VoxelShape Y_BOX_WEST = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 0.6, 1.0, 1.0));

    public PipeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(3.0f, 3.0f).m_60955_().m_60922_(Blocks::neverAllowSpawn).m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public float[] getHookTransforms(LevelReader levelReader, BlockPos pos, Direction facing) {
        if (levelReader.m_8055_(pos).m_61143_((Property)BaseLightBlock.HANG_DIRECTION) == Direction.UP) {
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        BlockEntity blockEntity = levelReader.m_7702_(pos);
        if (blockEntity instanceof FixtureProvider) {
            FixtureProvider fixtureProvider = (FixtureProvider)blockEntity;
            if (fixtureProvider.getFixture().getHangType() == HangType.BRACE_BAR) {
                return new float[]{0.0f, -0.35f, 0.0f};
            }
            return new float[]{0.0f, 0.5f, 0.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Y) {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            for (Direction dir : Direction.values()) {
                BlockState blockState;
                if (dir.m_122434_() == Direction.Axis.Y || !((blockState = level.m_8055_(pos.m_121945_(dir))).m_60734_() instanceof HangableBlock) || blockState.m_61143_((Property)HangableBlock.HANG_DIRECTION) != dir.m_122424_()) continue;
                VoxelShape extensionShape = null;
                switch (dir) {
                    case SOUTH: {
                        extensionShape = this.Y_BOX_SOUTH;
                        break;
                    }
                    case NORTH: {
                        extensionShape = this.Y_BOX_NORTH;
                        break;
                    }
                    case EAST: {
                        extensionShape = this.Y_BOX_EAST;
                        break;
                    }
                    case WEST: {
                        extensionShape = this.Y_BOX_WEST;
                    }
                }
                shapes.add(extensionShape);
            }
            return Shapes.m_83124_((VoxelShape)this.Y_BOX, (VoxelShape[])shapes.toArray(new VoxelShape[0]));
        }
        if (level.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_() instanceof HangableBlock) {
            VoxelShape ogShape = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? this.Z_BOX : this.X_BOX;
            VoxelShape extensionShape = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? this.Z_BOX_DOWN : this.X_BOX_DOWN;
            return Shapes.m_83110_((VoxelShape)ogShape, (VoxelShape)extensionShape);
        }
        if (level.m_8055_(pos.m_121945_(Direction.UP)).m_60734_() instanceof HangableBlock) {
            VoxelShape ogShape = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? this.Z_BOX : this.X_BOX;
            VoxelShape extensionShape = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? this.Z_BOX_UP : this.X_BOX_UP;
            return Shapes.m_83110_((VoxelShape)ogShape, (VoxelShape)extensionShape);
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? this.Z_BOX : (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Y ? this.Y_BOX : this.X_BOX);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem blockItem;
        Block block;
        Item item;
        if (!player.m_21120_(hand).m_41619_() && (item = player.m_21120_(hand).m_41720_()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof HangableBlock) {
            HangableBlock hangableBlock = (HangableBlock)block;
            BlockPos offset = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Y ? pos.m_121945_(player.m_6350_().m_122424_()) : (hit.m_82434_() == Direction.UP ? pos.m_121945_(Direction.UP) : pos.m_121945_(Direction.DOWN));
            if (!level.m_8055_(offset).m_60795_()) {
                return InteractionResult.FAIL;
            }
            Direction hangDirection = Direction.UP;
            if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Y) {
                hangDirection = player.m_6350_();
            } else if (hit.m_82434_() == Direction.UP) {
                hangDirection = Direction.DOWN;
            }
            Direction facingDirection = hangableBlock.getLightFacing(hangDirection, player);
            level.m_7731_(offset, (BlockState)((BlockState)((BlockState)hangableBlock.m_49966_().m_61124_((Property)HangableBlock.FACING, (Comparable)facingDirection)).m_61124_((Property)HangableBlock.HANGING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HangableBlock.HANG_DIRECTION, (Comparable)hangDirection), 2);
            if (!player.m_7500_()) {
                if (player.m_21120_(hand).m_41613_() > 1) {
                    player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                } else {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_41852_));
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

