/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.dmx;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class SavedClientNetworkManager {
    private static final SavedClientNetworkManager INSTANCE = new SavedClientNetworkManager();
    private static final Gson GSON = new Gson();
    private final Path savePath;
    private final Map<String, UUID> ipToNetworkIdMap = new HashMap<String, UUID>();

    public static SavedClientNetworkManager getInstance() {
        return INSTANCE;
    }

    public SavedClientNetworkManager() {
        this.savePath = new File(Minecraft.m_91087_().f_91069_, "local/dmx_networks.json").toPath();
        if (Files.exists(this.savePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.savePath);){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                for (String s : jsonObject.keySet()) {
                    this.ipToNetworkIdMap.put(s, UUID.fromString(jsonObject.get(s).getAsString()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public UUID getNetworkFromIP(String ip) {
        return this.ipToNetworkIdMap.get(ip);
    }

    private void save() {
        String json = GSON.toJson(this.ipToNetworkIdMap);
        try {
            Files.createDirectories(this.savePath.getParent(), new FileAttribute[0]);
            Files.writeString(this.savePath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveNetworkForIP(String ip, UUID networkId) {
        this.ipToNetworkIdMap.put(ip, networkId);
        this.save();
    }
}

