/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.client.gui.screen;

import dev.imabad.theatrical.TheatricalClient;
import dev.imabad.theatrical.client.gui.widgets.BetterCheckbox;
import dev.imabad.theatrical.client.gui.widgets.BetterStringWidget;
import dev.imabad.theatrical.client.gui.widgets.LabeledEditBox;
import dev.imabad.theatrical.net.ConfigureConfigurationCard;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ConfigurationCardScreen
extends Screen {
    private final ResourceLocation GUI = new ResourceLocation("theatrical", "textures/gui/blank.png");
    protected final int imageWidth;
    protected final int imageHeight;
    protected int xCenter;
    protected int yCenter;
    protected GridLayout layout;
    private LabeledEditBox dmxAddress;
    private LabeledEditBox dmxUniverse;
    private Checkbox autoIncrement;
    private BetterCheckbox enableUniverse;
    private BetterCheckbox enableAddress;
    private UUID networkId = UUIDUtil.NULL;
    private CompoundTag itemData;

    public ConfigurationCardScreen(CompoundTag itemData) {
        super((Component)Component.m_237115_((String)"screen.configurationcard"));
        this.imageWidth = 176;
        this.imageHeight = 126;
        this.itemData = itemData;
        if (itemData.m_128403_("network")) {
            this.networkId = itemData.m_128342_("network");
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.layout = new GridLayout();
        this.layout.m_264211_().m_264356_().m_264174_(10);
        this.layout.m_264188_((LayoutElement)new BetterStringWidget((Component)Component.m_237115_((String)"screen.configurationcard"), this.f_96547_).setColor(0x404040).setShadow(false), 1, 1, 1, 4);
        this.dmxUniverse = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 50, 10, (Component)Component.m_237115_((String)"artneti.dmxUniverse"));
        if (this.itemData.m_128441_("dmxUniverse")) {
            this.dmxUniverse.m_94144_(Integer.toString(this.itemData.m_128451_("dmxUniverse")));
        } else {
            this.dmxUniverse.m_94144_("0");
        }
        this.layout.m_264167_((LayoutElement)this.dmxUniverse, 2, 1, 1, 4, LayoutSettings.m_264214_().m_264356_().m_264623_().m_264174_(10));
        this.enableUniverse = new BetterCheckbox(this.xCenter, this.yCenter, 10, 10, (Component)Component.m_237115_((String)"artneti.dmxUniverse.enable"), this.itemData.m_128471_("universeEnabled"));
        this.dmxUniverse.f_93623_ = this.enableUniverse.m_93840_();
        this.enableUniverse.setOnChange(aBoolean -> {
            this.dmxUniverse.f_93623_ = aBoolean;
        });
        this.layout.m_264167_((LayoutElement)this.enableUniverse, 2, 2, 1, 1, LayoutSettings.m_264214_().m_264463_().m_264623_());
        this.layout.m_264188_((LayoutElement)new CycleButton.Builder(networkId -> {
            if (TheatricalClient.getArtNetManager().getKnownNetworks().containsKey(networkId)) {
                return Component.m_237113_((String)TheatricalClient.getArtNetManager().getKnownNetworks().get(networkId));
            }
            return Component.m_237113_((String)"Unknown");
        }).m_232500_(CycleButton.ValueListSupplier.m_232504_((Collection)Stream.concat(Stream.of(UUIDUtil.NULL), TheatricalClient.getArtNetManager().getKnownNetworks().keySet().stream()).collect(Collectors.toList()))).m_168929_().m_168948_((Object)this.networkId).m_168936_(this.xCenter, this.yCenter, 150, 20, (Component)Component.m_237115_((String)"screen.artnetconfig.network"), (obj, val) -> {
            this.networkId = val;
        }), 3, 1, 1, 4);
        this.dmxAddress = new LabeledEditBox(this.f_96547_, this.xCenter, this.yCenter, 50, 10, (Component)Component.m_237115_((String)"fixture.dmxStart"));
        if (this.itemData.m_128441_("dmxAddress")) {
            this.dmxAddress.m_94144_(Integer.toString(this.itemData.m_128451_("dmxAddress")));
        } else {
            this.dmxAddress.m_94144_("0");
        }
        this.layout.m_264167_((LayoutElement)this.dmxAddress, 4, 1, 1, 4, LayoutSettings.m_264214_().m_264356_().m_264623_().m_264174_(10));
        this.enableAddress = new BetterCheckbox(this.xCenter, this.yCenter, 10, 10, (Component)Component.m_237115_((String)"artneti.dmxAddress.enable"), this.itemData.m_128471_("addressEnabled"));
        this.dmxAddress.f_93623_ = this.enableAddress.m_93840_();
        this.enableAddress.setOnChange(aBoolean -> {
            this.dmxAddress.f_93623_ = aBoolean;
        });
        this.layout.m_264167_((LayoutElement)this.enableAddress, 4, 2, 1, 1, LayoutSettings.m_264214_().m_264463_().m_264623_());
        this.autoIncrement = new Checkbox(this.xCenter, this.yCenter, 150, 20, (Component)Component.m_237115_((String)"screen.configurationcard.autoincrement"), this.itemData.m_128471_("autoIncrement"));
        this.layout.m_264188_((LayoutElement)this.autoIncrement, 5, 1, 1, 4);
        this.layout.m_264188_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"artneti.save"), button -> this.update()).m_252794_(this.xCenter, this.yCenter).m_253046_(100, 20).m_253136_(), 6, 1, 1, 4);
        this.refreshLayout();
        this.m_267719_();
    }

    protected void refreshLayout() {
        if (this.layout == null) {
            return;
        }
        this.layout.m_264036_();
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    protected void m_267719_() {
        FrameLayout.m_267781_((LayoutElement)this.layout, (ScreenRectangle)this.m_264198_());
    }

    protected void update() {
        try {
            int dmx = Integer.parseInt(this.dmxAddress.m_94155_());
            if (dmx > 512 || dmx < 0) {
                return;
            }
            int universe = Integer.parseInt(this.dmxUniverse.m_94155_());
            if (universe < 0) {
                return;
            }
            new ConfigureConfigurationCard(this.networkId, dmx, universe, this.autoIncrement.m_93840_(), this.enableUniverse.m_93840_(), this.enableAddress.m_93840_()).sendToServer();
            Minecraft.m_91087_().m_91152_(null);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_280273_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_280273_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderWindow(guiGraphics);
    }

    private void renderWindow(GuiGraphics guiGraphics) {
        int layoutHeight = 0;
        if (this.layout != null) {
            layoutHeight = this.layout.m_93694_();
        }
        int relX = (this.f_96543_ - this.imageWidth) / 2;
        int relY = (this.f_96544_ - layoutHeight) / 2;
        guiGraphics.m_280411_(this.GUI, relX, relY, this.imageWidth, layoutHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean m_7043_() {
        return false;
    }
}

