/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.net.artnet;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.imabad.theatrical.Theatrical;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.net.TheatricalNet;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public class SendArtNetData
extends BaseC2SMessage {
    private final UUID networkId;
    private final int universe;
    private final byte[] artNetData;

    public SendArtNetData(UUID networkId, int universe, byte[] data) {
        this.networkId = networkId;
        this.universe = universe;
        this.artNetData = data;
    }

    public SendArtNetData(FriendlyByteBuf buf) {
        this.networkId = buf.m_130259_();
        this.universe = buf.readInt();
        this.artNetData = buf.m_130052_();
    }

    public MessageType getType() {
        return TheatricalNet.SEND_ARTNET_TO_SERVER;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.networkId);
        buf.writeInt(this.universe);
        buf.m_130087_(this.artNetData);
    }

    public void handle(NetworkManager.PacketContext context) {
        Level level = context.getPlayer().m_9236_();
        if (level.m_7654_() != null) {
            DMXNetwork network = DMXNetworkData.getInstance((Level)level.m_7654_().m_129783_()).getNetwork(this.networkId);
            UUID uuid = context.getPlayer().m_20148_();
            if (network != null) {
                if (network.isMember(uuid) && network.canSendDMX(uuid)) {
                    Collection<DMXConsumer> consumers = network.getConsumers(this.universe);
                    if (consumers != null) {
                        consumers.forEach(consumer -> consumer.consume(this.artNetData));
                    }
                } else {
                    Theatrical.LOGGER.info("{} tried to send ArtNet data to a network ({}) that they don't have permissions for", (Object)context.getPlayer().m_7755_().getString(), (Object)network.name());
                }
            } else {
                Theatrical.LOGGER.info("{} tried to send ArtNet data to a network that doesn't exist.", (Object)context.getPlayer().m_7755_().getString());
            }
        }
    }
}

