/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.control;

import dev.imabad.theatrical.api.dmx.BelongsToNetwork;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BasicLightingDeskBlockEntity
extends ClientSyncBlockEntity
implements BelongsToNetwork {
    private int ticks = 0;
    private byte[] faders = new byte[12];
    private final byte[] actualDMX = new byte[12];
    private int currentStep = 0;
    private HashMap<Integer, StoredCue> storedSteps = new HashMap();
    private StoredCue activeCue;
    private boolean isRunMode = false;
    private int fadeInTicks = 0;
    private int fadeOutTicks = 0;
    private int fadeInTicksRemaining = 0;
    private int fadeOutTicksRemaining = 0;
    private byte[] perTickOut;
    private byte[] perTickIn;
    private boolean isFadingOut = false;
    private byte grandMaster = (byte)-1;
    private UUID networkId = UUIDUtil.NULL;
    private int universe = 0;

    public BasicLightingDeskBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.BASIC_LIGHTING_DESK.get(), blockPos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        if (level.isClientSide) {
            return;
        }
        if (be instanceof BasicLightingDeskBlockEntity) {
            BasicLightingDeskBlockEntity beL = (BasicLightingDeskBlockEntity)be;
            beL.tick();
        }
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks >= 1) {
            if (this.isFadingOut) {
                if (this.fadeOutTicksRemaining > 0) {
                    --this.fadeOutTicksRemaining;
                    this.doFadeTickOut();
                } else {
                    this.isFadingOut = false;
                }
            } else if (this.fadeInTicksRemaining > 0) {
                --this.fadeInTicksRemaining;
                this.doFadeTickIn();
            }
            this.ticks = 0;
            byte[] dmx = new byte[512];
            for (int i = 0; i < this.faders.length; ++i) {
                dmx[i] = (byte)(this.convertByteToInt(this.faders[i]) * (this.convertByteToInt(this.grandMaster) / 255.0f));
            }
            this.update(dmx);
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void update(byte[] data) {
        Collection<DMXConsumer> consumers;
        DMXNetwork dmxData;
        if (this.level != null && this.level.getServer() != null && (dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId)) != null && (consumers = dmxData.getConsumers(this.universe)) != null) {
            consumers.forEach(consumer -> consumer.consume(data));
        }
    }

    public float convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public byte[] getFaders() {
        return this.faders;
    }

    @Override
    public void write(CompoundTag compoundTag) {
        if (compoundTag == null) {
            compoundTag = new CompoundTag();
        }
        compoundTag.putByteArray("faders", this.faders);
        CompoundTag compoundNBT = new CompoundTag();
        for (int key : this.storedSteps.keySet()) {
            compoundNBT.put(Integer.toString(key), (Tag)this.storedSteps.get(key).toNBT());
        }
        compoundTag.put("storedSteps", (Tag)compoundNBT);
        compoundTag.putInt("currentStep", this.currentStep);
        compoundTag.putByte("grandMaster", this.grandMaster);
        compoundTag.putBoolean("isRunMode", this.isRunMode);
        compoundTag.putInt("fadeInTicks", this.fadeInTicks);
        compoundTag.putInt("fadeOutTicks", this.fadeOutTicks);
        if (this.networkId != null) {
            compoundTag.putUUID("network", this.networkId);
        }
        compoundTag.putInt("universe", this.universe);
    }

    @Override
    public void read(CompoundTag compoundTag) {
        if (compoundTag.contains("faders")) {
            this.faders = compoundTag.getByteArray("faders");
        }
        if (compoundTag.contains("storedSteps")) {
            this.storedSteps = new HashMap();
            CompoundTag compoundNBT = compoundTag.getCompound("storedSteps");
            for (String key : compoundNBT.getAllKeys()) {
                int stepNumber = Integer.parseInt(key);
                this.storedSteps.put(stepNumber, new StoredCue().fromNBT(compoundNBT.getCompound(key)));
            }
        }
        if (compoundTag.contains("currentStep")) {
            this.currentStep = compoundTag.getInt("currentStep");
        }
        if (compoundTag.contains("grandMaster")) {
            this.grandMaster = compoundTag.getByte("grandMaster");
        }
        if (compoundTag.contains("isRunMode")) {
            this.isRunMode = compoundTag.getBoolean("isRunMode");
        }
        if (compoundTag.contains("fadeInTicks")) {
            this.fadeInTicks = compoundTag.getInt("fadeInTicks");
        }
        if (compoundTag.contains("fadeOutTicks")) {
            this.fadeOutTicks = compoundTag.getInt("fadeOutTicks");
        }
        if (compoundTag.contains("network")) {
            this.networkId = compoundTag.getUUID("network");
        }
        if (compoundTag.contains("universe")) {
            this.universe = compoundTag.getInt("universe");
        }
    }

    public void setFaders(byte[] faders) {
        this.faders = Arrays.copyOf(faders, faders.length);
        this.setChanged();
    }

    public void setFader(int fader, int value) {
        if (fader != -1) {
            this.faders[fader] = (byte)value;
        } else {
            this.grandMaster = (byte)value;
        }
        this.setChanged();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public byte getGrandMaster() {
        return this.grandMaster;
    }

    public boolean isRunMode() {
        return this.isRunMode;
    }

    public void toggleMode() {
        this.isRunMode = !this.isRunMode;
        this.setChanged();
    }

    public void clickButton() {
        if (this.isRunMode()) {
            this.recallNextStep();
        } else {
            this.storeCurrentFaders();
        }
    }

    public void moveForward() {
        if (this.isRunMode) {
            this.currentStep = this.getNextStep();
        } else {
            ++this.currentStep;
            if (this.storedSteps.containsKey(this.currentStep)) {
                byte[] faders = this.storedSteps.get(this.currentStep).getFaders();
                this.setFaders(faders);
            }
        }
    }

    public void moveBack() {
        if (this.isRunMode) {
            this.currentStep = this.getPreviousStep();
        } else {
            if (this.currentStep - 1 < 0) {
                return;
            }
            --this.currentStep;
            if (this.storedSteps.containsKey(this.currentStep)) {
                byte[] faders = this.storedSteps.get(this.currentStep).getFaders();
                this.setFaders(faders);
            }
        }
    }

    public HashMap<Integer, StoredCue> getStoredSteps() {
        return this.storedSteps;
    }

    private void doFadeTickIn() {
        for (int i = 0; i < this.faders.length; ++i) {
            this.faders[i] = (byte)(this.faders[i] - this.perTickIn[i]);
        }
    }

    private void doFadeTickOut() {
        for (int i = 0; i < this.faders.length; ++i) {
            this.faders[i] = (byte)(this.faders[i] - this.perTickOut[i]);
        }
    }

    private void recallNextStep() {
        int i;
        if (this.storedSteps.size() < this.currentStep) {
            return;
        }
        StoredCue previousCue = this.activeCue;
        if (!this.storedSteps.containsKey(this.currentStep)) {
            return;
        }
        StoredCue storedCue = this.storedSteps.get(this.currentStep);
        if (previousCue != null && previousCue.fadeOutTicks > 0) {
            this.isFadingOut = true;
            this.fadeOutTicksRemaining = previousCue.getFadeOutTicks();
            this.perTickOut = new byte[12];
            for (i = 0; i < this.faders.length; ++i) {
                this.perTickOut[i] = (byte)(this.convertByteToInt(this.faders[i]) / (float)this.fadeOutTicksRemaining);
            }
        }
        if (storedCue.fadeInTicks > 0) {
            this.fadeInTicksRemaining = storedCue.getFadeInTicks();
            this.perTickIn = new byte[12];
            for (i = 0; i < this.faders.length; ++i) {
                this.perTickIn[i] = this.isFadingOut ? (byte)(-this.convertByteToInt(storedCue.getFaders()[i]) / (float)this.fadeInTicksRemaining) : (byte)((this.convertByteToInt(this.faders[i]) - this.convertByteToInt(storedCue.getFaders()[i])) / (float)this.fadeInTicksRemaining);
            }
        } else {
            byte[] faders = storedCue.getFaders();
            this.setFaders(faders);
        }
        this.activeCue = storedCue;
        this.currentStep = this.getNextStep();
        this.setChanged();
    }

    private Integer getFirst() {
        return (Integer)this.storedSteps.keySet().stream().min(Integer::compareTo).get();
    }

    private Integer getNextStep() {
        if (this.storedSteps.size() > 0) {
            Optional<Integer> nextSteps = this.storedSteps.keySet().stream().filter(integer -> integer > this.currentStep).min(Integer::compareTo);
            return nextSteps.orElseGet(this::getFirst);
        }
        return this.currentStep;
    }

    private Integer getPreviousStep() {
        if (this.storedSteps.size() > 0) {
            Optional<Integer> nextSteps = this.storedSteps.keySet().stream().filter(integer -> integer < this.currentStep).sorted(Integer::compareTo).max(Comparator.naturalOrder());
            return nextSteps.orElseGet(() -> (Integer)this.storedSteps.keySet().stream().sorted(Integer::compareTo).max(Comparator.naturalOrder()).get());
        }
        return this.currentStep;
    }

    private void storeCurrentFaders() {
        StoredCue storedCue = new StoredCue(Arrays.copyOf(this.faders, this.faders.length), this.fadeInTicks, this.fadeOutTicks);
        this.storedSteps.put(this.currentStep, storedCue);
        ++this.currentStep;
        this.setChanged();
    }

    public int getFadeInTicks() {
        return this.fadeInTicks;
    }

    public void setFadeInTicks(int fadeInTicks) {
        this.fadeInTicks = fadeInTicks;
    }

    public int getFadeOutTicks() {
        return this.fadeOutTicks;
    }

    public void setFadeOutTicks(int fadeOutTicks) {
        this.fadeOutTicks = fadeOutTicks;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(UUID newNetworkId) {
        if (newNetworkId == this.networkId) {
            return;
        }
        this.networkId = newNetworkId;
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public static class StoredCue {
        private byte[] faders;
        private int fadeInTicks;
        private int fadeOutTicks;

        public StoredCue() {
        }

        public StoredCue(byte[] faders, int fadeInTicks, int fadeOutTicks) {
            this.faders = faders;
            this.fadeInTicks = fadeInTicks;
            this.fadeOutTicks = fadeOutTicks;
        }

        public CompoundTag toNBT() {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.putByteArray("faders", this.faders);
            compoundNBT.putInt("fadeIn", this.fadeInTicks);
            compoundNBT.putInt("fadeOut", this.fadeOutTicks);
            return compoundNBT;
        }

        public StoredCue fromNBT(CompoundTag nbt) {
            this.faders = nbt.getByteArray("faders");
            this.fadeInTicks = nbt.getInt("fadeIn");
            this.fadeOutTicks = nbt.getInt("fadeOut");
            return this;
        }

        public byte[] getFaders() {
            return this.faders;
        }

        public int getFadeInTicks() {
            return this.fadeInTicks;
        }

        public int getFadeOutTicks() {
            return this.fadeOutTicks;
        }
    }
}

