/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.interfaces;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.fixtures.Fixtures;
import dev.imabad.theatrical.util.RndUtils;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneInterfaceBlockEntity
extends ClientSyncBlockEntity
implements DMXConsumer {
    private int channelStartPoint;
    private int dmxUniverse = 0;
    private int redstoneOutput = 0;
    private RDMDeviceId deviceId;
    private UUID networkId = UUIDUtil.NULL;

    public RedstoneInterfaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.REDSTONE_INTERFACE.get(), blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        compoundTag.putInt("channelCount", 1);
        compoundTag.putInt("channelStartPoint", this.channelStartPoint);
        compoundTag.putInt("dmxUniverse", this.dmxUniverse);
        if (this.deviceId != null) {
            compoundTag.putByteArray("deviceId", this.deviceId.toBytes());
        }
        if (this.networkId != null) {
            compoundTag.putUUID("network", this.networkId);
        }
    }

    @Override
    public void read(CompoundTag compoundTag) {
        this.channelStartPoint = compoundTag.getInt("channelStartPoint");
        if (compoundTag.contains("dmxUniverse")) {
            this.dmxUniverse = compoundTag.getInt("dmxUniverse");
        }
        if (compoundTag.contains("deviceId")) {
            this.deviceId = new RDMDeviceId(compoundTag.getByteArray("deviceId"));
        }
        if (compoundTag.contains("network")) {
            this.networkId = compoundTag.getUUID("network");
        }
    }

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    public int getChannelStart() {
        return this.channelStartPoint;
    }

    @Override
    public int getUniverse() {
        return this.dmxUniverse;
    }

    public int getRedstoneOutput() {
        return this.redstoneOutput;
    }

    @Override
    public RDMDeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    public int getDeviceTypeId() {
        return 4;
    }

    @Override
    public String getModelName() {
        return "Redstone Interface";
    }

    @Override
    public ResourceLocation getFixtureId() {
        return Fixtures.REDSTONE_INTERFACE.getId();
    }

    @Override
    public int getActivePersonality() {
        return 0;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(UUID networkId) {
        if (networkId == this.networkId) {
            return;
        }
        this.removeConsumer();
        this.networkId = networkId;
        this.addConsumer();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    private void generateDeviceId() {
        byte[] bytes = new byte[4];
        if (this.level != null) {
            RndUtils.nextBytes(this.level.getRandom(), bytes);
        } else {
            new Random().nextBytes(bytes);
        }
        this.deviceId = new RDMDeviceId(32752, bytes);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    @Override
    public void consume(byte[] dmxValues) {
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 1) {
            return;
        }
        int newOutput = (int)Math.round(Mth.map((double)this.convertByteToInt(ourValues[0]), (double)0.0, (double)255.0, (double)0.0, (double)15.0));
        if (newOutput != this.redstoneOutput) {
            this.redstoneOutput = newOutput;
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    public void setChannelStartPoint(int channelStartPoint) {
        this.channelStartPoint = channelStartPoint;
        this.setChanged();
        this.updateConsumer();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public void setUniverse(int universe) {
        if (this.dmxUniverse == universe) {
            return;
        }
        this.removeConsumer();
        this.dmxUniverse = universe;
        this.addConsumer();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    private void updateConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.updateConsumer(this);
        }
    }

    private void addConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId);
        if (dmxData != null) {
            if (this.deviceId == null) {
                this.generateDeviceId();
            }
            dmxData.addConsumer(this.getBlockPos(), this);
        }
    }

    private void removeConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.removeConsumer(this, this.getBlockPos());
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level != null && !level.isClientSide) {
            this.addConsumer();
        }
    }

    public void setRemoved() {
        if (this.level != null && !this.level.isClientSide) {
            this.removeConsumer();
        }
        super.setRemoved();
    }

    @Override
    public String getTranslationKey() {
        return "block.theatrical.redstone_interface";
    }
}

