/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import ch.bildspur.artnet.rdm.RDMDeviceId;
import dev.imabad.theatrical.api.dmx.DMXConsumer;
import dev.imabad.theatrical.blockentities.light.BaseLightBlockEntity;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.util.RndUtils;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseDMXConsumerLightBlockEntity
extends BaseLightBlockEntity
implements DMXConsumer {
    private int channelCount;
    private int channelStartPoint;
    private int dmxUniverse;
    private RDMDeviceId deviceId;
    private UUID networkId = UUIDUtil.NULL;

    public BaseDMXConsumerLightBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        super.write(compoundTag);
        compoundTag.putInt("channelCount", this.channelCount);
        compoundTag.putInt("channelStartPoint", this.channelStartPoint);
        compoundTag.putInt("dmxUniverse", this.dmxUniverse);
        if (this.deviceId != null) {
            compoundTag.putByteArray("deviceId", this.deviceId.toBytes());
        }
        compoundTag.putUUID("network", this.networkId);
    }

    @Override
    public void read(CompoundTag compoundTag) {
        super.read(compoundTag);
        this.channelCount = compoundTag.getInt("channelCount");
        this.channelStartPoint = compoundTag.getInt("channelStartPoint");
        if (compoundTag.contains("dmxUniverse")) {
            this.dmxUniverse = compoundTag.getInt("dmxUniverse");
        }
        if (compoundTag.contains("deviceId")) {
            this.deviceId = new RDMDeviceId(compoundTag.getByteArray("deviceId"));
        }
        if (compoundTag.contains("network")) {
            this.networkId = compoundTag.getUUID("network");
        }
    }

    private void generateDeviceId() {
        byte[] bytes = new byte[4];
        if (this.level != null) {
            RndUtils.nextBytes(this.level.getRandom(), bytes);
        } else {
            new Random().nextBytes(bytes);
        }
        this.deviceId = new RDMDeviceId(32752, bytes);
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getChannelStart() {
        return this.channelStartPoint;
    }

    @Override
    public int getUniverse() {
        return this.dmxUniverse;
    }

    @Override
    public RDMDeviceId getDeviceId() {
        return this.deviceId;
    }

    @Override
    public UUID getNetworkId() {
        return this.networkId;
    }

    public void setUniverse(int dmxUniverse) {
        if (this.dmxUniverse == dmxUniverse) {
            return;
        }
        this.removeConsumer();
        this.dmxUniverse = dmxUniverse;
        this.addConsumer();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public void setChannelCount(int channelCount) {
        this.channelCount = channelCount;
    }

    public void setChannelStartPoint(int channelStartPoint) {
        if (this.channelStartPoint == channelStartPoint) {
            return;
        }
        this.channelStartPoint = channelStartPoint;
        this.updateConsumer();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    private void updateConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.updateConsumer(this);
        }
    }

    private void removeConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId);
        if (dmxData != null) {
            dmxData.removeConsumer(this, this.getBlockPos());
        }
    }

    private void addConsumer() {
        DMXNetwork dmxData = DMXNetworkData.getInstance((Level)this.level.getServer().overworld()).getNetwork(this.networkId);
        if (dmxData != null) {
            if (this.deviceId == null) {
                this.generateDeviceId();
            }
            dmxData.addConsumer(this.getBlockPos(), this);
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level != null && !level.isClientSide) {
            this.addConsumer();
        }
    }

    @Override
    public void setRemoved() {
        if (this.level != null && !this.level.isClientSide) {
            this.removeConsumer();
        }
        super.setRemoved();
    }

    @Override
    public void setNetworkId(UUID networkId) {
        if (networkId == this.networkId) {
            return;
        }
        this.removeConsumer();
        this.networkId = networkId;
        this.addConsumer();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }
}

