/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.light;

import dev.imabad.theatrical.api.Fixture;
import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.light.BaseDMXConsumerLightBlockEntity;
import dev.imabad.theatrical.blocks.light.MovingLightBlock;
import dev.imabad.theatrical.fixtures.Fixtures;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MovingLightBlockEntity
extends BaseDMXConsumerLightBlockEntity {
    public MovingLightBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.setChannelCount(7);
    }

    public MovingLightBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntities.MOVING_LIGHT.get(), pos, state);
    }

    @Override
    public Fixture getFixture() {
        return (Fixture)Fixtures.MOVING_LIGHT.get();
    }

    @Override
    public void consume(byte[] dmxValues) {
        int newTilt;
        int newPan;
        int newFocus;
        int newBlue;
        int newGreen;
        int newRed;
        int start = this.getChannelStart() > 0 ? this.getChannelStart() - 1 : 0;
        byte[] ourValues = Arrays.copyOfRange(dmxValues, start, start + this.getChannelCount());
        if (ourValues.length < 7) {
            return;
        }
        if (this.storePrev()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
        boolean hasUpdated = false;
        int newIntensity = this.convertByteToInt(ourValues[0]);
        if (this.intensity != newIntensity) {
            this.intensity = newIntensity;
            hasUpdated = true;
        }
        if (this.red != (newRed = this.convertByteToInt(ourValues[1]))) {
            this.red = newRed;
            hasUpdated = true;
        }
        if (this.green != (newGreen = this.convertByteToInt(ourValues[2]))) {
            this.green = newGreen;
            hasUpdated = true;
        }
        if (this.blue != (newBlue = this.convertByteToInt(ourValues[3]))) {
            this.blue = newBlue;
            hasUpdated = true;
        }
        if (this.focus != (newFocus = this.convertByteToInt(ourValues[4]))) {
            this.focus = newFocus;
            hasUpdated = true;
        }
        if (this.pan != (newPan = (int)((float)(this.convertByteToInt(ourValues[5]) * 360) / 255.0f) - 180)) {
            this.pan = newPan;
            hasUpdated = true;
        }
        if (this.tilt != (newTilt = (int)((float)(this.convertByteToInt(ourValues[6]) * 270) / 255.0f) - 225)) {
            this.tilt = newTilt;
            hasUpdated = true;
        }
        if (hasUpdated) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public int getDeviceTypeId() {
        return 1;
    }

    @Override
    public String getModelName() {
        return "Moving Head";
    }

    @Override
    public ResourceLocation getFixtureId() {
        return Fixtures.MOVING_LIGHT.getId();
    }

    @Override
    public int getActivePersonality() {
        return 0;
    }

    public int convertByteToInt(byte val) {
        return Byte.toUnsignedInt(val);
    }

    @Override
    public boolean isUpsideDown() {
        return (Boolean)this.getBlockState().getValue((Property)MovingLightBlock.HANGING) != false && this.getBlockState().getValue((Property)MovingLightBlock.HANG_DIRECTION) == Direction.UP;
    }

    @Override
    public int getBasePan() {
        return 0;
    }

    @Override
    public String getTranslationKey() {
        return "block.theatrical.moving_light";
    }
}

